/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.system.util.IItemSelector;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.IPlantable;

enum ItemPriorityLevel {
    ENCHANTED(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return is.func_77948_v();
        }
    }),
    SHINYARMORTOOLS(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            Item item = is.func_77973_b();
            if (item instanceof ItemArmor) {
                ItemArmor.ArmorMaterial armorMat = ((ItemArmor)item).func_82812_d();
                return armorMat == ItemArmor.ArmorMaterial.IRON || armorMat == ItemArmor.ArmorMaterial.GOLD || armorMat == ItemArmor.ArmorMaterial.DIAMOND;
            }
            if (item instanceof ItemTool || item instanceof ItemSword) {
                Item.ToolMaterial toolMat = this.getMaterial(item);
                return toolMat == Item.ToolMaterial.IRON || toolMat == Item.ToolMaterial.GOLD || toolMat == Item.ToolMaterial.EMERALD;
            }
            return false;
        }

        private Item.ToolMaterial getMaterial(Item item) {
            String matName;
            String string = item instanceof ItemTool ? ((ItemTool)item).func_77861_e() : (matName = item instanceof ItemSword ? ((ItemSword)item).func_150932_j() : null);
            if (matName == null) {
                return null;
            }
            for (Item.ToolMaterial mat : Item.ToolMaterial.values()) {
                if (!mat.toString().equals(matName)) continue;
                return mat;
            }
            return null;
        }
    }),
    SHINYBLOCKS(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            if (!(is.func_77973_b() instanceof ItemBlock)) {
                return false;
            }
            Block block = Block.func_149634_a((Item)is.func_77973_b());
            return block == Blocks.field_150484_ah || block == Blocks.field_150340_R || block == Blocks.field_150339_S || block == Blocks.field_150475_bE || block == Blocks.field_150451_bX || block == Blocks.field_150371_ca;
        }
    }),
    SHINYITEMS(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            Item item = is.func_77973_b();
            return item == Items.field_151045_i || item == Items.field_151043_k || item == Items.field_151042_j || item == Items.field_151074_bl || item == Items.field_151166_bC;
        }
    }),
    IRONMAT(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return is.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)is.func_77973_b()).func_149688_o() == Material.field_151573_f : is.func_77973_b() instanceof ItemMinecart;
        }
    }),
    ENDER(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            Item item = is.func_77973_b();
            return item == Items.field_151079_bi || item == Items.field_151061_bv || item == ItemList.end_powder || item == ItemList.transference_gem || item == ItemList.spatial_dash_gem;
        }
    }),
    FOOD(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return is.func_77975_n() == EnumAction.eat;
        }
    }),
    POTION(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return is.func_77973_b() == Items.field_151068_bn || is.func_77973_b() == Items.field_151062_by;
        }
    }),
    PLANTS(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            Item item = is.func_77973_b();
            if (item instanceof IPlantable) {
                return true;
            }
            if (!(item instanceof ItemBlock)) {
                return false;
            }
            Block block = Block.func_149634_a((Item)item);
            return block == BlockList.death_flower || block == BlockList.crossed_decoration && is.func_77960_j() == 6;
        }
    }),
    WOOD(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return is.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)is.func_77973_b()).func_149688_o() == Material.field_151575_d : is.func_77973_b() == Items.field_151055_y;
        }
    }),
    GROUNDMAT(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            if (is.func_77973_b() instanceof ItemBlock) {
                Material mat = Block.func_149634_a((Item)is.func_77973_b()).func_149688_o();
                return mat == Material.field_151576_e || mat == Material.field_151577_b || mat == Material.field_151578_c || mat == Material.field_151595_p;
            }
            return false;
        }
    }),
    RANDOM(new IItemSelector(){

        @Override
        public boolean isValid(ItemStack is) {
            return true;
        }
    });

    static final ItemPriorityLevel[] values;
    private IItemSelector selector;

    private ItemPriorityLevel(IItemSelector selector) {
        this.selector = selector;
    }

    public boolean isValid(ItemStack is) {
        return this.selector.isValid(is);
    }

    static {
        values = ItemPriorityLevel.values();
    }
}

