/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.entity.fx.FXType;
import chylex.hee.item.ItemAbstractEnergyAcceptor;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.types.TransferenceGemEnhancements;
import chylex.hee.mechanics.misc.GemSideEffects;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemTransferenceGem
extends ItemAbstractEnergyAcceptor {
    private static final GemData clientCache = new GemData();
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public int getMaxDamage(ItemStack is) {
        return this.calculateMaxDamage(is, TransferenceGemEnhancements.CAPACITY);
    }

    @Override
    public boolean canAcceptEnergy(ItemStack is) {
        return is.func_77960_j() > 0;
    }

    @Override
    public void onEnergyAccepted(ItemStack is) {
        is.func_77964_b(is.func_77960_j() - 2);
    }

    @Override
    public int getEnergyPerUse(ItemStack is) {
        return 3;
    }

    @Override
    protected float getRegenSpeedMultiplier() {
        return 0.06f;
    }

    @Override
    public void func_77663_a(ItemStack is, World world, Entity entity, int slot, boolean isHeld) {
        if (ItemUtil.getTagRoot(is, false).func_74764_b("cooldown")) {
            byte cooldown = is.func_77978_p().func_74771_c("cooldown");
            if ((cooldown = (byte)(cooldown - 1)) <= 0) {
                is.func_77978_p().func_82580_o("cooldown");
            } else {
                is.func_77978_p().func_74774_a("cooldown", cooldown);
            }
        }
        super.func_77663_a(is, world, entity, slot, isHeld);
    }

    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (super.func_77648_a(is, player, world, x, y, z, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!world.field_72995_K && side == 1 && player.func_70093_af()) {
            GemData data = new GemData();
            data.set(player.field_71093_bK, x, y, z);
            data.saveToItemStack(is);
            PacketPipeline.sendToAllAround(player.field_71093_bK, x, y, z, 64.0, new C20Effect(FXType.Basic.GEM_LINK, x, y, z));
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        return world.field_72995_K || player.func_70093_af() ? is : this.tryTeleportEntity(is, player, (Entity)player);
    }

    public boolean func_111207_a(ItemStack is, EntityPlayer player, EntityLivingBase entity) {
        if (entity instanceof IBossDisplayData || !EnhancementHandler.hasEnhancement(is, TransferenceGemEnhancements.BEAST) || player.func_70093_af()) {
            return false;
        }
        this.tryTeleportEntity(is, player, (Entity)entity);
        return true;
    }

    public void func_77622_d(ItemStack is, World world, EntityPlayer player) {
        player.func_71064_a((StatBase)AchievementManager.TRANSFERENCE_GEM, 1);
    }

    public ItemStack tryTeleportEntity(ItemStack is, EntityPlayer player, Entity entity) {
        if (entity.func_70115_ae() || entity.field_70153_n != null || !is.func_77942_o()) {
            return is;
        }
        if (ItemUtil.getTagRoot(is, false).func_74764_b("cooldown")) {
            return is;
        }
        GemData gemData = new GemData();
        gemData.set(is.func_77978_p());
        if (gemData.isLinked() && entity.field_71093_bK == gemData.dim) {
            int itemDamage = is.func_77960_j();
            if (itemDamage >= is.func_77958_k()) {
                return is;
            }
            boolean isLiving = entity instanceof EntityLivingBase;
            PacketPipeline.sendToAllAround(entity, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.GEM_TELEPORT_FROM, entity));
            this.damageItem(is, (EntityLivingBase)player);
            if (isLiving) {
                ((EntityLivingBase)entity).func_70634_a((double)gemData.x + 0.5, (double)gemData.y + 1.001, (double)gemData.z + 0.5);
            }
            entity.func_70012_b((double)gemData.x + 0.5, (double)gemData.y + 1.001, (double)gemData.z + 0.5, entity.field_70177_z, entity.field_70125_A);
            entity.field_70143_R = 0.0f;
            float percBroken = (float)itemDamage / (float)is.func_77958_k();
            if (percBroken > 0.66f && entity.field_70170_p.field_73012_v.nextFloat() * 1.4f < percBroken) {
                GemSideEffects.performRandomEffect(entity, percBroken);
            }
            ItemUtil.getTagRoot(is, true).func_74774_a("cooldown", (byte)50);
            PacketPipeline.sendToAllAround(entity, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.GEM_TELEPORT_TO, entity));
            CausatumUtils.increase(player, CausatumMeters.ITEM_USAGE, 1.0f);
        }
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack is, int pass) {
        return ItemUtil.getTagRoot(is, false).func_74764_b("cooldown") ? 0xC0C0C0 : super.func_82790_a(is, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List textLines, boolean showAdvancedInfo) {
        if (is.func_77942_o()) {
            ItemTransferenceGem.clientCache.set(is.func_77978_p());
            if (clientCache.isLinked()) {
                textLines.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"item.transferenceGem.info.linked", (Object[])new Object[0]));
                if (showAdvancedInfo) {
                    textLines.add(EnumChatFormatting.GRAY.toString() + "DIM " + clientCache.dim + ", X " + clientCache.x + ", Y " + clientCache.y + ", Z " + clientCache.z);
                }
            }
        }
        EnhancementHandler.appendEnhancementNames(is, textLines);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack is) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack is, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.iconArray[ItemTransferenceGem.getIcon(is)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack is) {
        return this.iconArray[ItemTransferenceGem.getIcon(is)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[3];
        for (int a = 0; a < this.iconArray.length; ++a) {
            this.iconArray[a] = iconRegister.func_94245_a("hardcoreenderexpansion:transference_gem_" + (a + 1));
        }
    }

    private static int getIcon(ItemStack is) {
        if (is.func_77960_j() == is.func_77958_k()) {
            return 2;
        }
        float percBroken = (float)is.func_77960_j() / (float)is.func_77958_k();
        return percBroken > 0.56f ? 1 : 0;
    }

    private static class GemData {
        private int dim;
        private int x;
        private int y;
        private int z;

        private GemData() {
        }

        private void set(NBTTagCompound nbt) {
            this.set(nbt.func_74764_b("HED_Gem_Dim") ? nbt.func_74762_e("HED_Gem_Dim") : -999, nbt.func_74762_e("HED_Gem_X"), nbt.func_74762_e("HED_Gem_Y"), nbt.func_74762_e("HED_Gem_Z"));
        }

        private void set(int dimension, int x, int y, int z) {
            this.dim = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isLinked() {
            return this.dim != -999;
        }

        public void saveToItemStack(ItemStack is) {
            NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
            nbt.func_74768_a("HED_Gem_Dim", this.dim);
            nbt.func_74768_a("HED_Gem_X", this.x);
            nbt.func_74768_a("HED_Gem_Y", this.y);
            nbt.func_74768_a("HED_Gem_Z", this.z);
        }
    }
}

