/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms.handler;

import chylex.hee.mechanics.charms.CharmPouchInfo;
import chylex.hee.mechanics.charms.handler.CharmEventsClient;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public final class CharmPouchHandlerClient {
    private static CharmPouchHandlerClient instance;
    private final CharmEventsClient eventsClient = new CharmEventsClient();
    private ItemStack activePouch;
    private CharmPouchInfo activePouchInfo;
    private long prevUpdateTime;
    private boolean prevHadPouch;
    private boolean refresh;

    public static void register() {
        instance = new CharmPouchHandlerClient();
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    public static void onActivePouchUpdate(EntityPlayer player, ItemStack is) {
        if (is != CharmPouchHandlerClient.instance.activePouch) {
            CharmPouchHandlerClient.instance.activePouch = is;
            CharmPouchHandlerClient.instance.refresh = true;
        }
        CharmPouchHandlerClient.instance.prevUpdateTime = player.field_70170_p.func_82737_E();
    }

    public static CharmPouchInfo getActivePouch() {
        return CharmPouchHandlerClient.instance.activePouchInfo;
    }

    private CharmPouchHandlerClient() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.activePouch = null;
            this.activePouchInfo = null;
            this.refresh = true;
        }
        if (this.activePouch != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() - this.prevUpdateTime > 4L) {
            this.activePouch = null;
            this.activePouchInfo = null;
            this.refresh = true;
        }
        if (this.refresh) {
            if (!this.prevHadPouch && this.activePouch != null) {
                this.activePouchInfo = new CharmPouchInfo(this.activePouch);
                this.prevHadPouch = true;
                MinecraftForge.EVENT_BUS.register((Object)this.eventsClient);
            } else if (this.prevHadPouch && this.activePouch == null) {
                this.activePouchInfo = null;
                this.prevHadPouch = false;
                MinecraftForge.EVENT_BUS.unregister((Object)this.eventsClient);
            }
        }
        this.refresh = false;
    }
}

