/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.player;

import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class PlayerDiscoveryList<P extends IKnowledgeObjectInstance<T>, T> {
    private final IObjectSerializer<T> serializer;
    private final Set<T> discoveredObjects = new HashSet<T>();

    public PlayerDiscoveryList(IObjectSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public boolean addObject(P object) {
        return this.discoveredObjects.add(object.getUnderlyingObject());
    }

    public boolean hasDiscoveredObject(P object) {
        return this.discoveredObjects.contains(object.getUnderlyingObject());
    }

    public NBTTagList saveToNBTList() {
        NBTTagList list = new NBTTagList();
        for (T object : this.discoveredObjects) {
            list.func_74742_a((NBTBase)new NBTTagString(this.serializer.serialize(object)));
        }
        return list;
    }

    public void loadFromNBTList(NBTTagList list) {
        this.discoveredObjects.clear();
        int count = list.func_74745_c();
        for (int a = 0; a < count; ++a) {
            T object = this.serializer.deserialize(list.func_150307_f(a));
            if (object == null) continue;
            this.discoveredObjects.add(KnowledgeObject.getObject(object).getObject().getUnderlyingObject());
        }
    }

    public static interface IObjectSerializer<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }
}

