/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.energy;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.EntityMiniBossEnderEye;
import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.entity.mob.EntityMobBabyEnderman;
import chylex.hee.entity.mob.EntityMobEndermage;
import chylex.hee.entity.mob.EntityMobEnderman;
import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.system.util.ItemDamagePair;
import chylex.hee.system.util.MathUtil;
import gnu.trove.map.hash.TObjectFloatHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class EnergyValues {
    private static final TObjectFloatHashMap<ItemDamagePair> items = new TObjectFloatHashMap();
    private static final TObjectFloatHashMap<Class<? extends EntityLivingBase>> mobs = new TObjectFloatHashMap();

    private static void setItemEnergy(Block block, float energyUnits) {
        items.put((Object)new ItemDamagePair(Item.func_150898_a((Block)block), -1), 0.12f * energyUnits);
    }

    private static void setItemEnergy(Item item, float energyUnits) {
        items.put((Object)new ItemDamagePair(item, -1), 0.12f * energyUnits);
    }

    public static boolean setItemEnergy(ItemDamagePair pair, float energyUnits) {
        if (!MathUtil.floatEquals(EnergyValues.getItemEnergy(new ItemStack(pair.item, 1, pair.damage == -1 ? 0 : pair.damage)), 0.0f)) {
            return false;
        }
        items.put((Object)pair, 0.12f * energyUnits);
        return true;
    }

    public static float getItemEnergy(ItemStack is) {
        for (ItemDamagePair idp : items.keySet()) {
            if (!idp.check(is)) continue;
            return items.get((Object)idp);
        }
        return 0.0f;
    }

    public static boolean setMobEnergy(Class<? extends EntityLivingBase> entityClass, float energyUnits) {
        if (mobs.containsKey(entityClass)) {
            return false;
        }
        mobs.put(entityClass, 0.12f * energyUnits);
        return true;
    }

    public static float getMobEnergy(EntityLivingBase entity) {
        float amt = mobs.get(entity.getClass());
        return amt == mobs.getNoEntryValue() ? 0.0f : amt;
    }

    private EnergyValues() {
    }

    static {
        EnergyValues.setItemEnergy(Blocks.field_150377_bs, 0.4f);
        EnergyValues.setItemEnergy(BlockList.end_terrain, 0.5f);
        EnergyValues.setItemEnergy(ItemList.adventurers_diary, 0.5f);
        EnergyValues.setItemEnergy(BlockList.persegrit, 0.55f);
        EnergyValues.setItemEnergy(ItemList.silverfish_blood, 0.65f);
        EnergyValues.setItemEnergy(ItemList.stardust, 0.75f);
        EnergyValues.setItemEnergy(ItemList.end_powder, 0.8f);
        EnergyValues.setItemEnergy(ItemList.igneous_rock, 0.9f);
        EnergyValues.setItemEnergy(ItemList.endium_ingot, 1.1f);
        EnergyValues.setItemEnergy(ItemList.knowledge_note, 1.2f);
        EnergyValues.setItemEnergy(Items.field_151079_bi, 1.5f);
        EnergyValues.setItemEnergy(ItemList.enhanced_ender_pearl, 1.65f);
        EnergyValues.setItemEnergy(BlockList.enhanced_brewing_stand, 1.65f);
        EnergyValues.setItemEnergy(BlockList.enhanced_tnt, 1.65f);
        EnergyValues.setItemEnergy(Items.field_151061_bv, 1.95f);
        EnergyValues.setItemEnergy(ItemList.instability_orb, 2.6f);
        EnergyValues.setItemEnergy(BlockList.spooky_log, 3.1f);
        EnergyValues.setItemEnergy(BlockList.spooky_leaves, 3.1f);
        EnergyValues.setItemEnergy(ItemList.rune, 3.25f);
        EnergyValues.setItemEnergy(ItemList.auricion, 3.4f);
        EnergyValues.setItemEnergy(Blocks.field_150477_bB, 3.75f);
        EnergyValues.setItemEnergy(ItemList.temple_caller, 4.0f);
        EnergyValues.setItemEnergy(ItemList.ectoplasm, 4.2f);
        EnergyValues.setItemEnergy(ItemList.spectral_tear, 4.2f);
        EnergyValues.setItemEnergy(BlockList.void_chest, 4.3f);
        EnergyValues.setItemEnergy(ItemList.charm, 4.8f);
        EnergyValues.setItemEnergy(ItemList.spatial_dash_gem, 5.5f);
        EnergyValues.setItemEnergy(ItemList.energy_wand_core, 6.2f);
        EnergyValues.setItemEnergy(ItemList.energy_wand, 6.4f);
        EnergyValues.setItemEnergy(ItemList.transference_gem, 7.8f);
        EnergyValues.setItemEnergy(BlockList.endium_block, 10.1f);
        EnergyValues.setItemEnergy(ItemList.living_matter, 10.5f);
        EnergyValues.setMobEnergy(EntityMobEnderman.class, 0.85f);
        EnergyValues.setMobEnergy(EntityMobAngryEnderman.class, 0.85f);
        EnergyValues.setMobEnergy(EntityMobHomelandEnderman.class, 0.85f);
        EnergyValues.setMobEnergy(EntityMobBabyEnderman.class, 0.4f);
        EnergyValues.setMobEnergy(EntityMobEndermage.class, 1.25f);
        EnergyValues.setMobEnergy(EntityMiniBossEnderEye.class, 6.5f);
        EnergyValues.setMobEnergy(EntityBossDragon.class, 24.0f);
    }
}

