/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.packets.client;

import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.events.CompendiumEventsClient;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import chylex.hee.packets.AbstractClientPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class C19CompendiumData
extends AbstractClientPacket {
    private PlayerCompendiumData data;

    public C19CompendiumData() {
    }

    public C19CompendiumData(EntityPlayer player) {
        this.data = CompendiumEvents.getPlayerData(player);
    }

    public C19CompendiumData(PlayerCompendiumData compendiumData) {
        this.data = compendiumData;
    }

    @Override
    public void write(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.data.saveNBTData(nbt);
        try {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            buffer.writeShort(compressed.length);
            buffer.writeBytes(compressed);
        }
        catch (IOException e) {
            buffer.writeShort(-1);
            e.printStackTrace();
        }
    }

    @Override
    public void read(ByteBuf buffer) {
        short len = buffer.readShort();
        if (len == -1) {
            return;
        }
        byte[] compressed = buffer.readBytes((int)len).array();
        try {
            this.data = new PlayerCompendiumData(CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityClientPlayerMP player) {
        if (this.data != null) {
            CompendiumEventsClient.loadClientData(this.data);
        }
    }
}

