/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.sound;

import chylex.hee.sound.EndMusicType;
import chylex.hee.sound.MusicManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;

@SideOnly(value=Side.CLIENT)
public final class CustomMusicTicker
extends MusicTicker {
    private static CustomMusicTicker instance;
    public static final MusicTicker.MusicType HEE_END;
    public static final MusicTicker.MusicType HEE_END_DRAGON_CALM;
    public static final MusicTicker.MusicType HEE_END_DRAGON_ANGRY;
    private final Minecraft mc;
    private final MusicTicker wrappedTicker;
    private final Random rand;
    private ISound currentMusic;
    private byte waitAfterNewSong = (byte)-1;
    private int vanillaMusicTimer = 100;
    private int endMusicTimer;
    private EndMusicType prevEndMusicType = EndMusicType.EXPLORATION;
    private EndMusicType playingEndMusicType = null;
    private boolean playingCustomJukebox;
    private int jukeboxDelay;

    public static boolean canPlayMusic() {
        return instance != null;
    }

    public static void stopMusicAndPlayJukebox(ISound music) {
        if (CustomMusicTicker.instance.currentMusic != null) {
            CustomMusicTicker.instance.mc.func_147118_V().func_147683_b(CustomMusicTicker.instance.currentMusic);
        }
        CustomMusicTicker.instance.currentMusic = music;
        CustomMusicTicker.instance.mc.func_147118_V().func_147682_a(music);
        CustomMusicTicker.instance.vanillaMusicTimer = 100;
        CustomMusicTicker.instance.jukeboxDelay = 160;
        CustomMusicTicker.instance.playingCustomJukebox = true;
    }

    public CustomMusicTicker(Minecraft mc, MusicTicker wrappedTicker) {
        super(mc);
        if (instance != null) {
            throw new IllegalStateException("CustomMusicTicker can only be created once!");
        }
        instance = this;
        this.mc = mc;
        this.wrappedTicker = wrappedTicker;
        this.rand = new Random();
        this.endMusicTimer = this.randomTimer(HEE_END);
    }

    public void func_73660_a() {
        if (this.playingCustomJukebox) {
            this.updateCustomJukeboxMusic();
        } else if (this.jukeboxDelay > 0) {
            --this.jukeboxDelay;
        } else if (this.mc.field_71441_e != null && this.mc.field_71441_e.field_73011_w.field_76574_g == 1 && MusicManager.enableCustomMusic) {
            this.updateEndMusic();
        } else if (MusicManager.removeVanillaDelay || this.wrappedTicker == null) {
            this.updateVanillaMusic();
        } else {
            this.wrappedTicker.func_73660_a();
        }
    }

    private void updateCustomJukeboxMusic() {
        boolean isTooFar;
        boolean bl = isTooFar = this.mc.field_71439_g != null && this.mc.field_71439_g.func_70011_f((double)this.currentMusic.func_147649_g(), (double)this.currentMusic.func_147654_h(), (double)this.currentMusic.func_147651_i()) > 64.0;
        if (this.currentMusic == null || !this.mc.func_147118_V().func_147692_c(this.currentMusic) || isTooFar && --this.vanillaMusicTimer < 0 || this.mc.field_71439_g == null) {
            if (this.mc.func_147118_V().func_147692_c(this.currentMusic)) {
                this.mc.func_147118_V().func_147683_b(this.currentMusic);
            }
            this.currentMusic = null;
            this.playingCustomJukebox = false;
            this.vanillaMusicTimer = Math.min(this.randomTimer(this.mc.func_147109_W()), this.vanillaMusicTimer);
        } else if (!isTooFar) {
            this.vanillaMusicTimer = 100;
        }
        this.resetEndMusic();
    }

    private void updateEndMusic() {
        EndMusicType type = EndMusicType.validateAndGetMusicType();
        if (!(this.prevEndMusicType.isBossMusic || this.playingEndMusicType != null && this.playingEndMusicType.isBossMusic || !type.isBossMusic)) {
            if (this.currentMusic != null) {
                this.mc.func_147118_V().func_147683_b(this.currentMusic);
            }
            this.currentMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)type.toMusicType().func_148635_a());
            this.mc.func_147118_V().func_147682_a(this.currentMusic);
            this.playingEndMusicType = type;
            this.waitAfterNewSong = (byte)100;
            if (this.endMusicTimer < HEE_END.func_148634_b()) {
                this.endMusicTimer = this.randomTimer(HEE_END);
            }
        }
        this.prevEndMusicType = type;
        if (this.currentMusic != null) {
            if (!(this.mc.func_147118_V().func_147692_c(this.currentMusic) || this.waitAfterNewSong >= 0 && (this.waitAfterNewSong = (byte)(this.waitAfterNewSong - 1)) >= 0)) {
                this.currentMusic = null;
                this.playingEndMusicType = null;
            }
        } else if (this.endMusicTimer == 0 || --this.endMusicTimer == 0) {
            this.currentMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)type.toMusicType().func_148635_a());
            this.mc.func_147118_V().func_147682_a(this.currentMusic);
            this.playingEndMusicType = type;
            this.waitAfterNewSong = (byte)100;
            this.endMusicTimer = this.randomTimer(type.toMusicType());
        }
    }

    private void updateVanillaMusic() {
        MusicTicker.MusicType type = this.mc.func_147109_W();
        if (this.currentMusic != null) {
            if (!type.func_148635_a().equals((Object)this.currentMusic.func_147650_b())) {
                this.mc.func_147118_V().func_147683_b(this.currentMusic);
                this.currentMusic = null;
                int n = this.vanillaMusicTimer = MusicManager.removeVanillaDelay ? this.getShortDelay() : MathHelper.func_76136_a((Random)this.rand, (int)(type.func_148634_b() / 8), (int)(type.func_148634_b() / 4));
            }
            if (!(this.mc.func_147118_V().func_147692_c(this.currentMusic) || this.waitAfterNewSong >= 0 && (this.waitAfterNewSong = (byte)(this.waitAfterNewSong - 1)) >= 0)) {
                this.currentMusic = null;
                int n = this.vanillaMusicTimer = MusicManager.removeVanillaDelay ? this.getShortDelay() : Math.min(this.randomTimer(type), this.vanillaMusicTimer);
            }
        }
        if (this.currentMusic == null && this.vanillaMusicTimer-- <= 0) {
            this.currentMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)type.func_148635_a());
            this.mc.func_147118_V().func_147682_a(this.currentMusic);
            this.waitAfterNewSong = (byte)100;
            this.vanillaMusicTimer = Integer.MAX_VALUE;
        }
        this.resetEndMusic();
    }

    private void resetEndMusic() {
        this.endMusicTimer = HEE_END.func_148634_b();
        this.prevEndMusicType = EndMusicType.EXPLORATION;
        this.playingEndMusicType = null;
    }

    private int randomTimer(MusicTicker.MusicType musicType) {
        int max;
        int min = musicType.func_148634_b();
        return min >= (max = musicType.func_148633_c()) ? max : this.rand.nextInt(max - min + 1) + min;
    }

    private int getShortDelay() {
        return 15 + this.rand.nextInt(8) * 5;
    }

    static {
        Class[][] enumClasses = new Class[][]{{MusicTicker.MusicType.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE}};
        HEE_END = (MusicTicker.MusicType)EnumHelper.addEnum((Class[][])enumClasses, MusicTicker.MusicType.class, (String)"HEE_END", (Object[])new Object[]{new ResourceLocation("hardcoreenderexpansion:music.game.end"), 3600, 8400});
        HEE_END_DRAGON_CALM = (MusicTicker.MusicType)EnumHelper.addEnum((Class[][])enumClasses, MusicTicker.MusicType.class, (String)"HEE_END_DRAGON_CALM", (Object[])new Object[]{new ResourceLocation("hardcoreenderexpansion:music.game.end.dragoncalm"), 0, 0});
        HEE_END_DRAGON_ANGRY = (MusicTicker.MusicType)EnumHelper.addEnum((Class[][])enumClasses, MusicTicker.MusicType.class, (String)"HEE_END_DRAGON_ANGRY", (Object[])new Object[]{new ResourceLocation("hardcoreenderexpansion:music.game.end.dragonangry"), 0, 0});
    }
}

