/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.sound;

import chylex.hee.sound.CustomMusicTicker;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.ReflectionUtils;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public final class MusicManager {
    public static boolean enableCustomMusic = true;
    public static boolean removeVanillaDelay = false;
    private boolean hasLoaded;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new MusicManager());
    }

    private MusicManager() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSoundLoad(SoundLoadEvent e) {
        if (this.hasLoaded || !enableCustomMusic && !removeVanillaDelay) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MusicTicker mcMusicTicker = (MusicTicker)ReflectionUtils.getFieldValue(mc, "mcMusicTicker");
        if (mcMusicTicker != null) {
            Class<?> tickerClass = mcMusicTicker.getClass();
            if (tickerClass == MusicTicker.class) {
                ReflectionUtils.setFieldValue(mc, "mcMusicTicker", (Object)new CustomMusicTicker(mc, null));
                Log.info("Successfully replaced music system.", new Object[0]);
            } else {
                ReflectionUtils.setFieldValue(mc, "mcMusicTicker", (Object)new CustomMusicTicker(mc, mcMusicTicker));
                Log.info("Successfully wrapped a music system replaced by another mod: $0", tickerClass.getName());
            }
            this.hasLoaded = true;
        }
    }
}

