/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata.types;

import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.system.logging.Log;
import chylex.hee.system.savedata.WorldSavefile;
import gnu.trove.iterator.TObjectFloatIterator;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CausatumSavefile
extends WorldSavefile {
    private Map<UUID, TObjectFloatHashMap<CausatumMeters>> levels = new HashMap<UUID, TObjectFloatHashMap<CausatumMeters>>();

    public CausatumSavefile() {
        super("causatum.nbt");
    }

    public float getTotalLevel(EntityPlayer player) {
        TObjectFloatHashMap<CausatumMeters> map = this.levels.get(player.func_110124_au());
        if (map == null) {
            return 0.0f;
        }
        float value = 0.0f;
        for (float val : map.values()) {
            value += val;
        }
        return value;
    }

    public float getLevel(UUID id, CausatumMeters meter) {
        TObjectFloatHashMap<CausatumMeters> map = this.levels.get(id);
        if (map == null) {
            return 0.0f;
        }
        float value = map.get((Object)meter);
        return value == map.getNoEntryValue() ? 0.0f : value;
    }

    public float increaseLevel(UUID id, CausatumMeters meter, float add) {
        float value;
        TObjectFloatHashMap map = this.levels.get(id);
        if (map == null) {
            map = new TObjectFloatHashMap();
            this.levels.put(id, (TObjectFloatHashMap<CausatumMeters>)map);
        }
        if ((value = map.adjustOrPutValue((Object)meter, add, add)) > (float)meter.limit) {
            value = meter.limit;
            map.put((Object)meter, value);
        }
        return value;
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        for (Map.Entry<UUID, TObjectFloatHashMap<CausatumMeters>> entry : this.levels.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            TObjectFloatIterator iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                iter.advance();
                tag.func_74776_a(((CausatumMeters)((Object)iter.key())).toString(), iter.value());
            }
            nbt.func_74782_a(entry.getKey().toString(), (NBTBase)tag);
        }
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        this.levels.clear();
        for (String key : nbt.func_150296_c()) {
            TObjectFloatHashMap map = new TObjectFloatHashMap();
            NBTTagCompound tag = nbt.func_74775_l(key);
            for (String name : tag.func_150296_c()) {
                try {
                    CausatumMeters meter = CausatumMeters.valueOf(name);
                    map.put((Object)meter, tag.func_74760_g(name));
                }
                catch (IllegalArgumentException e) {
                    Log.error("Unknown CausatumMeters entry: " + name, new Object[0]);
                }
            }
            this.levels.put(UUID.fromString(key), (TObjectFloatHashMap<CausatumMeters>)map);
        }
    }
}

