/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.fx.FXType;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.misc.PlayerTransportBeacons;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.tileentity.TileEntityAbstractEnergyInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityTransportBeacon
extends TileEntityAbstractEnergyInventory {
    private boolean hasEnergy;
    private boolean noTampering;
    private int actualX;
    private int actualY = -1;
    private int actualZ;
    private float beamAngle;

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.actualY == -1) {
                this.actualX = this.field_145851_c;
                this.actualY = this.field_145848_d;
                this.actualZ = this.field_145849_e;
            }
            if (this.field_145851_c == this.actualX && this.field_145848_d == this.actualY && this.field_145849_e == this.actualZ && this.field_145850_b.field_73011_w.field_76574_g == 1) {
                if (!this.noTampering) {
                    this.noTampering = true;
                    this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockList.transport_beacon, 0, 1);
                }
            } else if (this.noTampering) {
                this.noTampering = false;
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockList.transport_beacon, 0, 0);
            }
        }
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.beamAngle += 1.5f;
            EntityPlayer player = HardcoreEnderExpansion.proxy.getClientSidePlayer();
            if (player.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 8.0 && (Math.abs(player.field_70142_S - player.field_70165_t) > 1.0E-4 || Math.abs(player.field_70137_T - player.field_70163_u) > 1.0E-4 || Math.abs(player.field_70136_U - player.field_70161_v) > 1.0E-4)) {
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean teleportPlayer(EntityPlayer player, int x, int z, PlayerTransportBeacons data) {
        if (!this.hasEnergy || !this.noTampering) {
            return false;
        }
        BlockPosM tmpPos = BlockPosM.tmp(x, 1, z);
        while (tmpPos.y < player.field_70170_p.func_72940_L()) {
            if (tmpPos.getBlock((IBlockAccess)this.field_145850_b) == BlockList.transport_beacon) {
                if (player.func_70115_ae()) {
                    player.func_70078_a(null);
                }
                player.field_70143_R = 0.0f;
                PacketPipeline.sendToAllAround((Entity)player, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.SIMPLE_TELEPORT, (Entity)player));
                player.func_70634_a((double)x + 0.5, (double)tmpPos.y + 1.0, (double)z + 0.5);
                PacketPipeline.sendToAllAround((Entity)player, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.SIMPLE_TELEPORT, (Entity)player));
                this.hasEnergy = false;
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockList.transport_beacon, 1, 0);
                return true;
            }
            ++tmpPos.y;
        }
        data.removeBeacon(x, z);
        return false;
    }

    public boolean func_145842_c(int eventId, int eventData) {
        HardcoreEnderExpansion.proxy.sendMessage(ModCommonProxy.MessageType.TRANSPORT_BEACON_GUI, new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, eventId, eventData});
        return true;
    }

    @Override
    protected byte getDrainTimer() {
        return 1;
    }

    @Override
    protected float getDrainAmount() {
        return 0.48f;
    }

    @Override
    protected boolean isWorking() {
        return !this.hasEnergy;
    }

    @Override
    protected void onWork() {
        this.hasEnergy = true;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockList.transport_beacon, 1, 1);
    }

    public float getBeamAngle() {
        return this.beamAngle;
    }

    public boolean hasEnergy() {
        return this.hasEnergy;
    }

    public boolean hasNotBeenTampered() {
        return this.noTampering;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("hasEng", this.hasEnergy);
        nbt.func_74772_a("actualPos", BlockPosM.tmp(this.actualX, this.actualY, this.actualZ).toLong());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasEnergy = nbt.func_74767_n("hasEng");
        BlockPosM actualPos = BlockPosM.fromNBT(nbt, "actualPos");
        this.actualX = actualPos.x;
        this.actualY = actualPos.y;
        this.actualZ = actualPos.z;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    public int[] func_94128_d(int side) {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    protected String getContainerDefaultName() {
        return "";
    }
}

