/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs;

import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public abstract class BlobGenerator
implements IWeightProvider {
    private final int weight;

    public BlobGenerator(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public abstract void generate(DecoratorFeatureGenerator var1, Random var2);

    public static final boolean genBlob(DecoratorFeatureGenerator gen, double x, double y, double z, double rad) {
        return BlobGenerator.genBlob(gen, x, y, z, rad, Blocks.field_150377_bs);
    }

    public static final boolean genBlob(DecoratorFeatureGenerator gen, double x, double y, double z, double rad, Block block) {
        boolean generatedSomething = false;
        double radSq = MathUtil.square(rad + 0.5);
        int size = MathUtil.ceil(rad);
        int ix = MathUtil.floor(x);
        int iy = MathUtil.floor(y);
        int iz = MathUtil.floor(z);
        ArrayList<BlockPosM> locs = new ArrayList<BlockPosM>();
        for (int xx = ix - size; xx <= ix + size; ++xx) {
            for (int yy = iy - size; yy <= iy + size; ++yy) {
                for (int zz = iz - size; zz <= iz + size; ++zz) {
                    if (!(MathUtil.distanceSquared((double)xx - x, (double)yy - y, (double)zz - z) <= radSq) || gen.getBlock(xx, yy, zz) == block || !gen.setBlock(xx, yy, zz, block)) continue;
                    generatedSomething = true;
                    locs.add(new BlockPosM(xx, yy, zz));
                }
            }
        }
        return generatedSomething;
    }
}

