/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui.controls;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityHowlerAlarm;

@SideOnly(value=Side.CLIENT)
public class GuiHowlerAlarmSlider
extends GuiButton {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/gui/GUIHowlerAlarm.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/gui/GUIHowlerAlarm.png");
    public float sliderValue;
    public boolean dragging;
    private int minValue = 0;
    private int maxValue = 256;
    private int step = 8;
    private String label;
    private TileEntityHowlerAlarm alarm;

    public GuiHowlerAlarmSlider(int id, int x, int y, String label, TileEntityHowlerAlarm alarm) {
        super(id, x, y, 107, 16, label);
        this.alarm = alarm;
        this.dragging = false;
        this.label = label;
        if (alarm.func_145831_w().field_72995_K) {
            this.maxValue = IC2NuclearControl.instance.maxAlarmRange;
        }
        int currentRange = alarm.getRange();
        if (alarm.func_145831_w().field_72995_K && currentRange > this.maxValue) {
            currentRange = this.maxValue;
        }
        this.sliderValue = ((float)currentRange - (float)this.minValue) / (float)(this.maxValue - this.minValue);
        this.field_146126_j = String.format(label, this.getNormalizedValue());
    }

    private int getNormalizedValue() {
        return (this.minValue + (int)Math.floor((float)(this.maxValue - this.minValue) * this.sliderValue)) / this.step * this.step;
    }

    private void setSliderPos(int targetX) {
        this.sliderValue = (float)(targetX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
        if (this.sliderValue < 0.0f) {
            this.sliderValue = 0.0f;
        }
        if (this.sliderValue > 1.0f) {
            this.sliderValue = 1.0f;
        }
        int newValue = this.getNormalizedValue();
        if (this.alarm.getRange() != newValue) {
            ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this.alarm, newValue);
        }
        this.field_146126_j = String.format(this.label, newValue);
    }

    public void func_146112_a(Minecraft minecraft, int targetX, int targetY) {
        if (this.field_146125_m) {
            minecraft.field_71446_o.func_110577_a(TEXTURE_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.dragging) {
                this.setSliderPos(targetX);
            }
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 131, 0, 8, 16);
            minecraft.field_71466_p.func_78276_b(this.field_146126_j, this.field_146128_h, this.field_146129_i - 12, 0x404040);
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int targetX, int j) {
        if (super.func_146116_c(minecraft, targetX, j)) {
            this.setSliderPos(targetX);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

