/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.modifiers;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.modifiers.MM_Webber;
import atomicstryker.infernalmobs.common.modifiers.MobModifier;
import atomicstryker.infernalmobs.common.modifiers.ModifierLoader;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class MM_Gravity
extends MobModifier {
    private static final Class<?>[] modBans = new Class[]{MM_Webber.class};
    private static final String[] suffix = new String[]{"ofRepulsion", "theFlipper"};
    private static final String[] prefix = new String[]{"repulsing", "sproing"};
    private static long coolDown;
    private static double maxDistanceSquared;
    private long nextAbilityUse = 0L;

    public MM_Gravity(@Nullable MobModifier next) {
        super("Gravity", next);
    }

    @Override
    public boolean onUpdate(EntityLivingBase mob) {
        EntityLivingBase target = this.getMobTarget();
        if (target instanceof EntityPlayer && !((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            this.tryAbility(mob, target);
        }
        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage) {
        if (!(source.func_76346_g() == null || !(source.func_76346_g() instanceof EntityLivingBase) || source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75102_a)) {
            this.tryAbility(mob, (EntityLivingBase)source.func_76346_g());
        }
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target) {
        if (target == null || !mob.func_70685_l((Entity)target) || mob.func_70068_e((Entity)target) >= maxDistanceSquared) {
            return;
        }
        long time = mob.field_70173_aa;
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + coolDown;
            double diffX = target.field_70165_t - mob.field_70165_t;
            double diffZ = target.field_70161_v - mob.field_70161_v;
            while (diffX * diffX + diffZ * diffZ < 1.0E-4) {
                diffX = (Math.random() - Math.random()) * 0.01;
                diffZ = (Math.random() - Math.random()) * 0.01;
            }
            mob.field_70170_p.func_72956_a((Entity)mob, "mob.irongolem.throw", 1.0f, (mob.field_70170_p.field_73012_v.nextFloat() - mob.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            if (mob.field_70170_p.field_72995_K || !(target instanceof EntityPlayerMP)) {
                MM_Gravity.knockBack(target, diffX, diffZ);
            } else {
                InfernalMobsCore.instance().sendKnockBackPacket((EntityPlayerMP)target, (float)diffX, (float)diffZ);
            }
        }
    }

    public static void knockBack(EntityLivingBase target, double x, double z) {
        target.field_70160_al = true;
        float normalizedPower = MathHelper.func_76133_a((double)(x * x + z * z));
        float knockPower = 0.8f;
        target.field_70159_w /= 2.0;
        target.field_70181_x /= 2.0;
        target.field_70179_y /= 2.0;
        target.field_70159_w -= x / (double)normalizedPower * (double)knockPower;
        target.field_70181_x += (double)knockPower;
        target.field_70179_y -= z / (double)normalizedPower * (double)knockPower;
        if (target.field_70181_x > (double)0.4f) {
            target.field_70181_x = 0.4f;
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }

    public static class Loader
    extends ModifierLoader<MM_Gravity> {
        public Loader() {
            super(MM_Gravity.class);
        }

        @Override
        public MM_Gravity make(@Nullable MobModifier next) {
            return new MM_Gravity(next);
        }

        @Override
        public void loadConfig(Configuration config) {
            coolDown = config.get(this.getModifierClassName(), "coolDownMillis", 5000.0, "Time between ability uses").getInt(5000) / 50;
            double maxDistance = config.get(this.getModifierClassName(), "maxDistance", 40, "Range of ability.").getDouble(40.0);
            maxDistanceSquared = maxDistance * maxDistance;
        }
    }
}

