/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botanicaladdons.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ninja.shadowfox.shadowfox_botany.api.ShadowFoxAPI;
import ninja.shadowfox.shadowfox_botany.api.trees.IIridescentSaplingVariant;
import ninja.shadowfox.shadowfox_botany.api.trees.IridescentSaplingBaseVariant;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.botanicaladdons.IridescentTree")
public class IridescentTree {
    protected static final String name = "Botanical Addons Iridescent Tree";

    @ZenMethod
    public static void addVariant(IItemStack blockSoil, IItemStack blockWood, IItemStack blockLeaves, int metaMin, int metaMax, int metaShift) {
        Object soil = InputHelper.toObject((IIngredient)blockSoil);
        Object wood = InputHelper.toObject((IIngredient)blockWood);
        Object leaves = InputHelper.toObject((IIngredient)blockLeaves);
        if (soil == null || !(soil instanceof ItemStack) || !InputHelper.isABlock((ItemStack)soil)) {
            LogHelper.logError("Soil must be a block.");
            return;
        }
        if (wood == null || !(wood instanceof ItemStack) || !InputHelper.isABlock((ItemStack)wood)) {
            LogHelper.logError("Wood must be a block.");
            return;
        }
        if (leaves == null || !(leaves instanceof ItemStack) || !InputHelper.isABlock((ItemStack)leaves)) {
            LogHelper.logError("Leaves must be a block.");
            return;
        }
        Block soilBlock = Block.func_149634_a((Item)((ItemStack)soil).func_77973_b());
        Block woodBlock = Block.func_149634_a((Item)((ItemStack)wood).func_77973_b());
        Block leavesBlock = Block.func_149634_a((Item)((ItemStack)leaves).func_77973_b());
        MineTweakerAPI.apply((IUndoableAction)new Add((IIridescentSaplingVariant)new IridescentSaplingBaseVariant(soilBlock, woodBlock, leavesBlock, metaMin, metaMax, metaShift)));
    }

    @ZenMethod
    public static void addVariant(IItemStack blockSoil, IItemStack blockWood, IItemStack blockLeaves, int metaMin, int metaMax) {
        IridescentTree.addVariant(blockSoil, blockWood, blockLeaves, metaMin, metaMax, 0);
    }

    @ZenMethod
    public static void addVariant(IItemStack blockSoil, IItemStack blockWood, IItemStack blockLeaves, int meta) {
        IridescentTree.addVariant(blockSoil, blockWood, blockLeaves, meta, meta, 0);
    }

    @ZenMethod
    public static void addVariant(IItemStack blockSoil, IItemStack blockWood, IItemStack blockLeaves) {
        IridescentTree.addVariant(blockSoil, blockWood, blockLeaves, 0, 15, 0);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack blockSoil) {
        Object soil = InputHelper.toObject((IIngredient)blockSoil);
        if (soil == null || !(soil instanceof ItemStack) || !InputHelper.isABlock((ItemStack)soil)) {
            LogHelper.logError("Soil must be a block.");
            return;
        }
        Block soilBlock = Block.func_149634_a((Item)((ItemStack)soil).func_77973_b());
        LinkedList<IIridescentSaplingVariant> recipes = new LinkedList<IIridescentSaplingVariant>();
        for (IIridescentSaplingVariant r : ShadowFoxAPI.treeVariants) {
            if (r == null || !(r instanceof IridescentSaplingBaseVariant) || r.getAcceptableSoils().get(0) != soilBlock) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, soilBlock.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<IIridescentSaplingVariant> {
        public Remove(List<IIridescentSaplingVariant> recipes) {
            super(IridescentTree.name, ShadowFoxAPI.treeVariants, recipes);
        }

        @Override
        public String getRecipeInfo(IIridescentSaplingVariant recipe) {
            return LogHelper.getStackDescription(new ItemStack((Block)recipe.getAcceptableSoils().get(0)));
        }
    }

    private static class Add
    extends BaseListAddition<IIridescentSaplingVariant> {
        public Add(IIridescentSaplingVariant recipe) {
            super(IridescentTree.name, ShadowFoxAPI.treeVariants);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IIridescentSaplingVariant recipe) {
            return LogHelper.getStackDescription(new ItemStack((Block)recipe.getAcceptableSoils().get(0)));
        }
    }
}

