/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry;

import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import java.util.ArrayList;
import java.util.List;
import modtweaker2.helpers.LogHelper;
import modtweaker2.utils.BaseListAddition;

public abstract class ForestryListAddition<T extends IForestryRecipe, C extends ICraftingProvider<T>>
extends BaseListAddition<T> {
    private final C craftingProvider;

    protected ForestryListAddition(String name, C craftingProvider) {
        super(name, new ArrayList(craftingProvider.recipes()));
        this.craftingProvider = craftingProvider;
    }

    protected ForestryListAddition(String name, C craftingProvider, List<T> recipes) {
        super(name, new ArrayList(craftingProvider.recipes()), recipes);
        this.craftingProvider = craftingProvider;
    }

    @Override
    protected abstract String getRecipeInfo(T var1);

    @Override
    public final void apply() {
        for (IForestryRecipe recipe : this.recipes) {
            if (recipe != null) {
                if (this.craftingProvider.addRecipe(recipe)) {
                    this.successful.add(recipe);
                    continue;
                }
                LogHelper.logError(String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                continue;
            }
            LogHelper.logError(String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    public final void undo() {
        for (IForestryRecipe recipe : this.successful) {
            if (recipe != null) {
                if (this.craftingProvider.removeRecipe(recipe)) continue;
                LogHelper.logError(String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                continue;
            }
            LogHelper.logError(String.format("Error removing %s Recipe: null object", this.name));
        }
    }
}

