/*
 * Decompiled with CFR 0.152.
 */
package com.github.wohaopa.MyCTMLib;

import com.github.wohaopa.MyCTMLib.CTMIconManager;
import com.github.wohaopa.MyCTMLib.GTNHIntegrationHelper;
import com.github.wohaopa.MyCTMLib.MyCTMLib;
import cpw.mods.fml.common.Loader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class Textures {
    public static Map<String, CTMIconManager> ctmIconMap = new ConcurrentHashMap<String, CTMIconManager>();
    public static Map<String, String[]> ctmReplaceMap = new ConcurrentHashMap<String, String[]>();
    public static Map<String, String> ctmAltMap = new ConcurrentHashMap<String, String>();
    public static boolean gtBlockCasings4CTM = false;
    public static boolean gtGregtechMetaCasingBlocks3CTM = false;
    public static boolean gtBWBlocksGlassCTM = false;
    public static final int[][] vertex = new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 1}};
    public static final ForgeDirection[][] forgeDirections = new ForgeDirection[][]{{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.DOWN, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.NORTH}, {ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.DOWN, ForgeDirection.SOUTH}};
    public static final ThreadLocal<int[]> threadLocalIconIdx = ThreadLocal.withInitial(() -> new int[4]);
    public static final ThreadLocal<boolean[]> threadLocalConnections = ThreadLocal.withInitial(() -> new boolean[8]);
    public static final ThreadLocal<float[][][]> threadInterpolationMatrix = ThreadLocal.withInitial(() -> new float[4][3][3]);

    public static boolean contain(String icon) {
        int firstColon = icon.indexOf(58);
        int secondColon = icon.indexOf(58, firstColon + 1);
        if (secondColon != -1) {
            icon = icon.substring(0, secondColon) + "&" + icon.substring(secondColon + 1).replace(":", "&");
        }
        boolean result = ctmIconMap.containsKey(icon);
        if (MyCTMLib.debugMode) {
            System.out.println("[CTM] contain(\"" + icon + "\") = " + result);
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            if (gtBlockCasings4CTM) {
                GTNHIntegrationHelper.setBlockCasings4CTM(false);
            }
            if (gtGregtechMetaCasingBlocks3CTM) {
                GTNHIntegrationHelper.setGregtechMetaCasingBlocks3CTM(false);
            }
            if (gtBWBlocksGlassCTM) {
                GTNHIntegrationHelper.setBWBlocksGlassCTM(false);
            }
        }
        return result;
    }

    public static boolean renderWorldBlock(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, double x, double y, double z, IIcon iIcon, ForgeDirection forgeDirection) {
        int firstColon;
        String icon = iIcon.func_94215_i();
        int secondColon = icon.indexOf(58, (firstColon = icon.indexOf(58)) + 1);
        if (secondColon != -1) {
            icon = icon.substring(0, secondColon) + "&" + icon.substring(secondColon + 1).replace(":", "&");
        }
        int[] iconIdx = threadLocalIconIdx.get();
        Textures.buildConnect(blockAccess, (int)x, (int)y, (int)z, iIcon, forgeDirection, iconIdx);
        CTMIconManager manager = ctmIconMap.get(icon);
        if (!manager.hasInited()) {
            manager.init();
        }
        float offset = 0.001f;
        switch (forgeDirection) {
            case DOWN: {
                Textures.renderFaceYNeg(renderBlocks, x, y + (double)offset, z, manager, iconIdx);
                break;
            }
            case UP: {
                Textures.renderFaceYPos(renderBlocks, x, y - (double)offset, z, manager, iconIdx);
                break;
            }
            case NORTH: {
                Textures.renderFaceZNeg(renderBlocks, x, y, z + (double)offset, manager, iconIdx);
                break;
            }
            case SOUTH: {
                Textures.renderFaceZPos(renderBlocks, x, y, z - (double)offset, manager, iconIdx);
                break;
            }
            case WEST: {
                Textures.renderFaceXNeg(renderBlocks, x + (double)offset, y, z, manager, iconIdx);
                break;
            }
            case EAST: {
                Textures.renderFaceXPos(renderBlocks, x - (double)offset, y, z, manager, iconIdx);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void setAO(float[][][] matrix, Tessellator tessellator, int i, int j, int index) {
        int x_offset = vertex[index][0];
        int y_offset = vertex[index][1];
        tessellator.func_78386_a(matrix[0][i + x_offset][j + y_offset], matrix[1][i + x_offset][j + y_offset], matrix[2][i + x_offset][j + y_offset]);
        tessellator.func_78380_c((int)matrix[3][i + x_offset][j + y_offset]);
    }

    public static void fillInterpolationMatrix(float[][] array, float valTopLeft, float valTopRight, float valBottomLeft, float valBottomRight) {
        array[0][0] = valTopLeft;
        array[1][0] = (valTopLeft + valTopRight) / 2.0f;
        array[2][0] = valTopRight;
        array[0][2] = valBottomLeft;
        array[1][2] = (valBottomLeft + valBottomRight) / 2.0f;
        array[2][2] = valBottomRight;
        array[0][1] = (array[0][0] + array[0][2]) / 2.0f;
        array[1][1] = (array[1][0] + array[1][2]) / 2.0f;
        array[2][1] = (array[2][0] + array[2][2]) / 2.0f;
    }

    public static void fillInterpolationMatrix(float[][][] matrix, RenderBlocks renderBlocks) {
        float[][] red = matrix[0];
        Textures.fillInterpolationMatrix(red, renderBlocks.field_147872_ap, renderBlocks.field_147848_as, renderBlocks.field_147852_aq, renderBlocks.field_147850_ar);
        float[][] green = matrix[1];
        Textures.fillInterpolationMatrix(green, renderBlocks.field_147846_at, renderBlocks.field_147856_aw, renderBlocks.field_147860_au, renderBlocks.field_147858_av);
        float[][] blue = matrix[2];
        Textures.fillInterpolationMatrix(blue, renderBlocks.field_147854_ax, renderBlocks.field_147833_aA, renderBlocks.field_147841_ay, renderBlocks.field_147839_az);
        float[][] bright = matrix[3];
        Textures.fillInterpolationMatrix(bright, renderBlocks.field_147864_al, renderBlocks.field_147870_ao, renderBlocks.field_147874_am, renderBlocks.field_147876_an);
    }

    public static void renderFaceYNeg(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                IIcon iIcon = manager.getIcon(iconIdxOut[i + j * 2]);
                double minU = iIcon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                double maxU = iIcon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                double minV = iIcon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                double maxV = iIcon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                if (renderBlocks.field_147859_h < 0.0 || renderBlocks.field_147861_i > 1.0) {
                    minU = iIcon.func_94209_e();
                    maxU = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147851_l < 0.0 || renderBlocks.field_147853_m > 1.0) {
                    minV = iIcon.func_94206_g();
                    maxV = iIcon.func_94210_h();
                }
                double d7 = maxU;
                double d8 = minU;
                double d9 = minV;
                double d10 = maxV;
                if (renderBlocks.field_147865_v == 2) {
                    minU = iIcon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                    minV = iIcon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                    maxU = iIcon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                    maxV = iIcon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                    d9 = minV;
                    d10 = maxV;
                    d7 = minU;
                    d8 = maxU;
                    minV = maxV;
                    maxV = d9;
                } else if (renderBlocks.field_147865_v == 1) {
                    minU = iIcon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                    minV = iIcon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                    maxU = iIcon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                    maxV = iIcon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                    d7 = maxU;
                    d8 = minU;
                    minU = maxU;
                    maxU = d8;
                    d9 = maxV;
                    d10 = minV;
                } else if (renderBlocks.field_147865_v == 3) {
                    minU = iIcon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                    maxU = iIcon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                    minV = iIcon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                    maxV = iIcon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                    d7 = maxU;
                    d8 = minU;
                    d9 = minV;
                    d10 = maxV;
                }
                double minX = x + renderBlocks.field_147859_h + 0.5 * (double)i;
                double maxX = x + renderBlocks.field_147861_i - (i == 0 ? 0.5 : 0.0);
                double minY = y + renderBlocks.field_147855_j;
                double minZ = z + renderBlocks.field_147851_l + 0.5 * (double)j;
                double maxZ = z + renderBlocks.field_147853_m - (j == 0 ? 0.5 : 0.0);
                if (renderBlocks.field_147838_g) {
                    double d = minX;
                    minX = maxX;
                    maxX = d;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, i, 1 - j, 0);
                    tessellator.func_78374_a(minX, minY, maxZ, d8, d10);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 3);
                    tessellator.func_78374_a(minX, minY, minZ, minU, minV);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 2);
                    tessellator.func_78374_a(maxX, minY, minZ, d7, d9);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 1);
                    tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
                    continue;
                }
                tessellator.func_78374_a(minX, minY, maxZ, d8, d10);
                tessellator.func_78374_a(minX, minY, minZ, minU, minV);
                tessellator.func_78374_a(maxX, minY, minZ, d7, d9);
                tessellator.func_78374_a(maxX, minY, maxZ, maxU, maxV);
            }
        }
    }

    public static void renderFaceYPos(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                IIcon iIcon = manager.getIcon(iconIdxOut[i + j * 2]);
                double minU = iIcon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                double maxU = iIcon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                double minV = iIcon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                double maxV = iIcon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                if (renderBlocks.field_147859_h < 0.0 || renderBlocks.field_147861_i > 1.0) {
                    minU = iIcon.func_94209_e();
                    maxU = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147851_l < 0.0 || renderBlocks.field_147853_m > 1.0) {
                    minV = iIcon.func_94206_g();
                    maxV = iIcon.func_94210_h();
                }
                double d7 = maxU;
                double d8 = minU;
                double d9 = minV;
                double d10 = maxV;
                if (renderBlocks.field_147867_u == 1) {
                    minU = iIcon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                    minV = iIcon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                    maxU = iIcon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                    maxV = iIcon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                    d9 = minV;
                    d10 = maxV;
                    d7 = minU;
                    d8 = maxU;
                    minV = maxV;
                    maxV = d9;
                } else if (renderBlocks.field_147867_u == 2) {
                    minU = iIcon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                    minV = iIcon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                    maxU = iIcon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                    maxV = iIcon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                    d7 = maxU;
                    d8 = minU;
                    minU = maxU;
                    maxU = d8;
                    d9 = maxV;
                    d10 = minV;
                } else if (renderBlocks.field_147867_u == 3) {
                    minU = iIcon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                    maxU = iIcon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                    minV = iIcon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                    maxV = iIcon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                    d7 = maxU;
                    d8 = minU;
                    d9 = minV;
                    d10 = maxV;
                }
                double minX = x + renderBlocks.field_147859_h + 0.5 * (double)i;
                double maxX = x + renderBlocks.field_147861_i - (i == 0 ? 0.5 : 0.0);
                double maxY = y + renderBlocks.field_147857_k;
                double minZ = z + renderBlocks.field_147851_l + 0.5 * (double)j;
                double maxZ = z + renderBlocks.field_147853_m - (j == 0 ? 0.5 : 0.0);
                if (renderBlocks.field_147838_g) {
                    double d = minX;
                    minX = maxX;
                    maxX = d;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, 1 - i, 1 - j, 0);
                    tessellator.func_78374_a(maxX, maxY, maxZ, maxU, maxV);
                    Textures.setAO(matrix, tessellator, 1 - i, 1 - j, 3);
                    tessellator.func_78374_a(maxX, maxY, minZ, d7, d9);
                    Textures.setAO(matrix, tessellator, 1 - i, 1 - j, 2);
                    tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
                    Textures.setAO(matrix, tessellator, 1 - i, 1 - j, 1);
                    tessellator.func_78374_a(minX, maxY, maxZ, d8, d10);
                    continue;
                }
                tessellator.func_78374_a(maxX, maxY, maxZ, maxU, maxV);
                tessellator.func_78374_a(maxX, maxY, minZ, d7, d9);
                tessellator.func_78374_a(minX, maxY, minZ, minU, minV);
                tessellator.func_78374_a(minX, maxY, maxZ, d8, d10);
            }
        }
    }

    public static void renderFaceZNeg(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d7;
                IIcon iIcon = manager.getIcon(iconIdxOut[i + j * 2]);
                double d3 = iIcon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                double d4 = iIcon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                if (renderBlocks.field_152631_f) {
                    d4 = iIcon.func_94214_a((1.0 - renderBlocks.field_147859_h) * 16.0);
                    d3 = iIcon.func_94214_a((1.0 - renderBlocks.field_147861_i) * 16.0);
                }
                double d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147857_k * 16.0);
                double d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147855_j * 16.0);
                if (renderBlocks.field_147842_e) {
                    d7 = d3;
                    d3 = d4;
                    d4 = d7;
                }
                if (renderBlocks.field_147859_h < 0.0 || renderBlocks.field_147861_i > 1.0) {
                    d3 = iIcon.func_94209_e();
                    d4 = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147855_j < 0.0 || renderBlocks.field_147857_k > 1.0) {
                    d5 = iIcon.func_94206_g();
                    d6 = iIcon.func_94210_h();
                }
                d7 = d4;
                double d8 = d3;
                double d9 = d5;
                double d10 = d6;
                if (renderBlocks.field_147875_q == 2) {
                    d3 = iIcon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                    d4 = iIcon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                    d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                    d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                    d9 = d5;
                    d10 = d6;
                    d7 = d3;
                    d8 = d4;
                    d5 = d6;
                    d6 = d9;
                } else if (renderBlocks.field_147875_q == 1) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d3 = d4;
                    d4 = d8;
                    d9 = d6;
                    d10 = d5;
                } else if (renderBlocks.field_147875_q == 3) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d9 = d5;
                    d10 = d6;
                }
                double d11 = x + renderBlocks.field_147859_h + (i == 0 ? 0.5 : 0.0);
                double d12 = x + renderBlocks.field_147861_i - 0.5 * (double)i;
                double d13 = y + renderBlocks.field_147855_j + (j == 0 ? 0.5 : 0.0);
                double d14 = y + renderBlocks.field_147857_k - 0.5 * (double)j;
                double d15 = z + renderBlocks.field_147851_l;
                if (renderBlocks.field_147838_g) {
                    double d = d11;
                    d11 = d12;
                    d12 = d;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, j, 1 - i, 0);
                    tessellator.func_78374_a(d11, d14, d15, d7, d9);
                    Textures.setAO(matrix, tessellator, j, 1 - i, 3);
                    tessellator.func_78374_a(d12, d14, d15, d3, d5);
                    Textures.setAO(matrix, tessellator, j, 1 - i, 2);
                    tessellator.func_78374_a(d12, d13, d15, d8, d10);
                    Textures.setAO(matrix, tessellator, j, 1 - i, 1);
                    tessellator.func_78374_a(d11, d13, d15, d4, d6);
                    continue;
                }
                tessellator.func_78374_a(d11, d14, d15, d7, d9);
                tessellator.func_78374_a(d12, d14, d15, d3, d5);
                tessellator.func_78374_a(d12, d13, d15, d8, d10);
                tessellator.func_78374_a(d11, d13, d15, d4, d6);
            }
        }
    }

    public static void renderFaceZPos(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d7;
                IIcon iIcon = manager.getIcon(iconIdxOut[i + j * 2]);
                if (renderBlocks.func_147744_b()) {
                    iIcon = renderBlocks.field_147840_d;
                }
                double d3 = iIcon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                double d4 = iIcon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                double d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147857_k * 16.0);
                double d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147855_j * 16.0);
                if (renderBlocks.field_147842_e) {
                    d7 = d3;
                    d3 = d4;
                    d4 = d7;
                }
                if (renderBlocks.field_147859_h < 0.0 || renderBlocks.field_147861_i > 1.0) {
                    d3 = iIcon.func_94209_e();
                    d4 = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147855_j < 0.0 || renderBlocks.field_147857_k > 1.0) {
                    d5 = iIcon.func_94206_g();
                    d6 = iIcon.func_94210_h();
                }
                d7 = d4;
                double d8 = d3;
                double d9 = d5;
                double d10 = d6;
                if (renderBlocks.field_147873_r == 1) {
                    d3 = iIcon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                    d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                    d4 = iIcon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                    d9 = d5 = (double)iIcon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                    d10 = d6;
                    d7 = d3;
                    d8 = d4;
                    d5 = d6;
                    d6 = d9;
                } else if (renderBlocks.field_147873_r == 2) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d3 = d4;
                    d4 = d8;
                    d9 = d6;
                    d10 = d5;
                } else if (renderBlocks.field_147873_r == 3) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d9 = d5;
                    d10 = d6;
                }
                double d11 = x + renderBlocks.field_147859_h + 0.5 * (double)i;
                double d12 = x + renderBlocks.field_147861_i - (i == 0 ? 0.5 : 0.0);
                double d13 = y + renderBlocks.field_147855_j + (j == 0 ? 0.5 : 0.0);
                double d14 = y + renderBlocks.field_147857_k - 0.5 * (double)j;
                double d15 = z + renderBlocks.field_147853_m;
                if (renderBlocks.field_147838_g) {
                    d11 = x + renderBlocks.field_147861_i;
                    d12 = x + renderBlocks.field_147859_h;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, i, j, 0);
                    tessellator.func_78374_a(d11, d14, d15, d3, d5);
                    Textures.setAO(matrix, tessellator, i, j, 3);
                    tessellator.func_78374_a(d11, d13, d15, d8, d10);
                    Textures.setAO(matrix, tessellator, i, j, 2);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    Textures.setAO(matrix, tessellator, i, j, 1);
                    tessellator.func_78374_a(d12, d14, d15, d7, d9);
                    continue;
                }
                tessellator.func_78374_a(d11, d14, d15, d3, d5);
                tessellator.func_78374_a(d11, d13, d15, d8, d10);
                tessellator.func_78374_a(d12, d13, d15, d4, d6);
                tessellator.func_78374_a(d12, d14, d15, d7, d9);
            }
        }
    }

    public static void renderFaceXNeg(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d7;
                IIcon iIcon = manager.getIcon(iconIdxOut[i * 2 + j]);
                if (renderBlocks.func_147744_b()) {
                    iIcon = renderBlocks.field_147840_d;
                }
                double d3 = iIcon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                double d4 = iIcon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                double d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147857_k * 16.0);
                double d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147855_j * 16.0);
                if (renderBlocks.field_147842_e) {
                    d7 = d3;
                    d3 = d4;
                    d4 = d7;
                }
                if (renderBlocks.field_147851_l < 0.0 || renderBlocks.field_147853_m > 1.0) {
                    d3 = iIcon.func_94209_e();
                    d4 = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147855_j < 0.0 || renderBlocks.field_147857_k > 1.0) {
                    d5 = iIcon.func_94206_g();
                    d6 = iIcon.func_94210_h();
                }
                d7 = d4;
                double d8 = d3;
                double d9 = d5;
                double d10 = d6;
                if (renderBlocks.field_147869_t == 1) {
                    d3 = iIcon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                    d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                    d4 = iIcon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                    d9 = d5;
                    d10 = d6;
                    d7 = d3;
                    d8 = d4;
                    d5 = d6;
                    d6 = d9;
                } else if (renderBlocks.field_147869_t == 2) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d3 = d4;
                    d4 = d8;
                    d9 = d6;
                    d10 = d5;
                } else if (renderBlocks.field_147869_t == 3) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d9 = d5;
                    d10 = d6;
                }
                double d11 = x + renderBlocks.field_147859_h;
                double d12 = y + renderBlocks.field_147855_j + (i == 0 ? 0.5 : 0.0);
                double d13 = y + renderBlocks.field_147857_k - 0.5 * (double)i;
                double d14 = z + renderBlocks.field_147851_l + 0.5 * (double)j;
                double d15 = z + renderBlocks.field_147853_m - (j == 0 ? 0.5 : 0.0);
                if (renderBlocks.field_147838_g) {
                    d14 = z + renderBlocks.field_147853_m;
                    d15 = z + renderBlocks.field_147851_l;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, i, 1 - j, 0);
                    tessellator.func_78374_a(d11, d13, d15, d7, d9);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 3);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 2);
                    tessellator.func_78374_a(d11, d12, d14, d8, d10);
                    Textures.setAO(matrix, tessellator, i, 1 - j, 1);
                    tessellator.func_78374_a(d11, d12, d15, d4, d6);
                    continue;
                }
                tessellator.func_78374_a(d11, d13, d15, d7, d9);
                tessellator.func_78374_a(d11, d13, d14, d3, d5);
                tessellator.func_78374_a(d11, d12, d14, d8, d10);
                tessellator.func_78374_a(d11, d12, d15, d4, d6);
            }
        }
    }

    public static void renderFaceXPos(RenderBlocks renderBlocks, double x, double y, double z, CTMIconManager manager, int[] iconIdxOut) {
        Tessellator tessellator = Loader.isModLoaded((String)"gtnhlib") ? GTNHIntegrationHelper.getGTNHLibTessellator() : Tessellator.field_78398_a;
        float[][][] matrix = threadInterpolationMatrix.get();
        if (renderBlocks.field_147863_w) {
            Textures.fillInterpolationMatrix(matrix, renderBlocks);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d7;
                IIcon iIcon = manager.getIcon(iconIdxOut[i * 2 + j]);
                double d3 = iIcon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                double d4 = iIcon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                if (renderBlocks.field_152631_f) {
                    d4 = iIcon.func_94214_a((1.0 - renderBlocks.field_147851_l) * 16.0);
                    d3 = iIcon.func_94214_a((1.0 - renderBlocks.field_147853_m) * 16.0);
                }
                double d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147857_k * 16.0);
                double d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147855_j * 16.0);
                if (renderBlocks.field_147842_e) {
                    d7 = d3;
                    d3 = d4;
                    d4 = d7;
                }
                if (renderBlocks.field_147851_l < 0.0 || renderBlocks.field_147853_m > 1.0) {
                    d3 = iIcon.func_94209_e();
                    d4 = iIcon.func_94212_f();
                }
                if (renderBlocks.field_147855_j < 0.0 || renderBlocks.field_147857_k > 1.0) {
                    d5 = iIcon.func_94206_g();
                    d6 = iIcon.func_94210_h();
                }
                d7 = d4;
                double d8 = d3;
                double d9 = d5;
                double d10 = d6;
                if (renderBlocks.field_147871_s == 2) {
                    d3 = iIcon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                    d5 = iIcon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                    d4 = iIcon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                    d9 = d5;
                    d10 = d6;
                    d7 = d3;
                    d8 = d4;
                    d5 = d6;
                    d6 = d9;
                } else if (renderBlocks.field_147871_s == 1) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d3 = d4;
                    d4 = d8;
                    d9 = d6;
                    d10 = d5;
                } else if (renderBlocks.field_147871_s == 3) {
                    d3 = iIcon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                    d4 = iIcon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                    d5 = iIcon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                    d6 = iIcon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                    d7 = d4;
                    d8 = d3;
                    d9 = d5;
                    d10 = d6;
                }
                double d11 = x + renderBlocks.field_147861_i;
                double d12 = y + renderBlocks.field_147855_j + (i == 0 ? 0.5 : 0.0);
                double d13 = y + renderBlocks.field_147857_k - 0.5 * (double)i;
                double d14 = z + renderBlocks.field_147851_l + (j == 0 ? 0.5 : 0.0);
                double d15 = z + renderBlocks.field_147853_m - 0.5 * (double)j;
                if (renderBlocks.field_147838_g) {
                    d14 = z + renderBlocks.field_147853_m;
                    d15 = z + renderBlocks.field_147851_l;
                }
                if (renderBlocks.field_147863_w) {
                    Textures.setAO(matrix, tessellator, 1 - i, j, 0);
                    tessellator.func_78374_a(d11, d12, d15, d8, d10);
                    Textures.setAO(matrix, tessellator, 1 - i, j, 3);
                    tessellator.func_78374_a(d11, d12, d14, d4, d6);
                    Textures.setAO(matrix, tessellator, 1 - i, j, 2);
                    tessellator.func_78374_a(d11, d13, d14, d7, d9);
                    Textures.setAO(matrix, tessellator, 1 - i, j, 1);
                    tessellator.func_78374_a(d11, d13, d15, d3, d5);
                    continue;
                }
                tessellator.func_78374_a(d11, d12, d15, d8, d10);
                tessellator.func_78374_a(d11, d12, d14, d4, d6);
                tessellator.func_78374_a(d11, d13, d14, d7, d9);
                tessellator.func_78374_a(d11, d13, d15, d3, d5);
            }
        }
    }

    public static void buildConnect(IBlockAccess blockAccess, int x, int y, int z, IIcon iIcon, ForgeDirection forgeDirection, int[] iconIdxOut) {
        int i;
        int i2;
        boolean[] connections = threadLocalConnections.get();
        ForgeDirection[] forgeDirections1 = forgeDirections[forgeDirection.ordinal()];
        for (i2 = 0; i2 < 4; ++i2) {
            IIcon i22 = Textures.getIcon(blockAccess, x + forgeDirections1[i2].offsetX, y + forgeDirections1[i2].offsetY, z + forgeDirections1[i2].offsetZ, forgeDirection);
            connections[i2] = Textures.isIconMatch(i22, iIcon);
        }
        for (i2 = 4; i2 < 8; ++i2) {
            int i23;
            int i1 = i2 - 4;
            int n = i23 = i2 - 3 == 4 ? 0 : i2 - 3;
            if (connections[i1] && connections[i23]) {
                IIcon ic = Textures.getIcon(blockAccess, x + forgeDirections1[i1].offsetX + forgeDirections1[i23].offsetX, y + forgeDirections1[i1].offsetY + forgeDirections1[i23].offsetY, z + forgeDirections1[i1].offsetZ + forgeDirections1[i23].offsetZ, forgeDirection);
                connections[i2] = Textures.isIconMatch(ic, iIcon);
                continue;
            }
            connections[i2] = false;
        }
        boolean hasThird = ctmAltMap.containsKey(iIcon.func_94215_i());
        iconIdxOut[0] = connections[7] ? 1 : (connections[3] && connections[0] ? 11 : (connections[3] ? 9 : (connections[0] ? 3 : 17)));
        iconIdxOut[1] = connections[4] ? 2 : (connections[0] && connections[1] ? 12 : (connections[0] ? 4 : (connections[1] ? 10 : 18)));
        iconIdxOut[2] = connections[6] ? 5 : (connections[2] && connections[3] ? 15 : (connections[2] ? 7 : (connections[3] ? 13 : 19)));
        iconIdxOut[3] = connections[5] ? 6 : (connections[1] && connections[2] ? 16 : (connections[1] ? 14 : (connections[2] ? 8 : 20)));
        boolean allDefault = true;
        for (i = 0; i < 4; ++i) {
            if (iconIdxOut[i] >= 17 && iconIdxOut[i] <= 20) continue;
            allDefault = false;
            break;
        }
        if (!allDefault && hasThird) {
            block9: for (i = 0; i < 4; ++i) {
                switch (iconIdxOut[i]) {
                    case 17: {
                        iconIdxOut[i] = 21;
                        continue block9;
                    }
                    case 18: {
                        iconIdxOut[i] = 22;
                        continue block9;
                    }
                    case 19: {
                        iconIdxOut[i] = 23;
                        continue block9;
                    }
                    case 20: {
                        iconIdxOut[i] = 24;
                    }
                }
            }
        }
    }

    public static boolean isIconMatch(IIcon target, IIcon candidate) {
        String[] candidateGroup;
        String candidateName;
        if (target == null || candidate == null) {
            return false;
        }
        String targetName = target.func_94215_i();
        if (targetName.equals(candidateName = candidate.func_94215_i())) {
            return true;
        }
        String[] targetGroup = ctmReplaceMap.get(targetName);
        if (targetGroup != null) {
            for (String v : targetGroup) {
                if (!v.equals(candidateName)) continue;
                return true;
            }
        }
        if ((candidateGroup = ctmReplaceMap.get(candidateName)) != null) {
            for (String v : candidateGroup) {
                if (!v.equals(targetName)) continue;
                return true;
            }
        }
        return false;
    }

    public static IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection direction) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block == null || block instanceof BlockAir) {
            return null;
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            try {
                return GTNHIntegrationHelper.getIcon(blockAccess, x, y, z, direction);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return block.func_149673_e(blockAccess, x, y, z, direction.ordinal());
    }
}

