/*
 * Decompiled with CFR 0.152.
 */
package com.github.wohaopa.MyCTMLib.mixins;

import cpw.mods.fml.common.Loader;
import io.github.tox1cozz.mixinbooterlegacy.ILateMixinLoader;
import io.github.tox1cozz.mixinbooterlegacy.LateMixin;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@LateMixin
public class LateMixinLoader
implements ILateMixinLoader {
    public static final Logger LOG = LogManager.getLogger((String)"GTNL");
    public static final String LOG_PREFIX = "[GTNL] ";
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            LOG.warn("[GTNL] Mixin config {} is not found in config map! It will never be loaded.", new Object[]{mixinConfig});
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static boolean modLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        LateMixinLoader.addMixinCFG("mixins.MyCTMLib.late.json", () -> Loader.isModLoaded((String)"gregtech"));
    }
}

