/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.interactable;

import codechicken.nei.NEIClientUtils;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InteractiveComponentGroup
implements Interactable {
    protected final Point position;
    protected final ImmutableList<DisplayComponent> components;
    protected final Tooltip slotTooltip;

    public InteractiveComponentGroup(Point pos, Iterable<DisplayComponent> components, Tooltip slotTooltip) {
        this.position = pos;
        this.components = ImmutableList.copyOf(components);
        this.slotTooltip = slotTooltip;
        Preconditions.checkState((!this.components.isEmpty() ? 1 : 0) != 0, (Object)"Must contain at least one component!");
    }

    public InteractiveComponentGroup(Slot slot, DisplayComponent ... components) {
        this(slot.position(), (Iterable<DisplayComponent>)ImmutableList.copyOf((Object[])components), slot.tooltip());
    }

    public InteractiveComponentGroup(Slot slot, Iterable<DisplayComponent> components) {
        this(slot.position(), components, slot.tooltip());
    }

    public int currentIndex(DiagramState diagramState) {
        return diagramState.cycleIndex(this.components.size());
    }

    public DisplayComponent currentComponent(DiagramState diagramState) {
        return (DisplayComponent)this.components.get(this.currentIndex(diagramState));
    }

    public Tooltip cycleTooltip(DiagramState diagramState) {
        if (this.components.size() <= 1) {
            return Tooltip.EMPTY_TOOLTIP;
        }
        int maxComponents = ConfigOptions.TOOLTIP_MAX_CYCLE_COUNT.get();
        if (!NEIClientUtils.shiftKey() || maxComponents <= 0) {
            String transKey = maxComponents > 0 ? "cycleindexwithshift" : "cycleindex";
            return Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.API.transf(transKey, this.currentIndex(diagramState) + 1, this.components.size())).build();
        }
        int numComponents = Math.min(this.components.size(), maxComponents);
        ImmutableList tooltipComponents = this.components.subList(0, numComponents);
        Tooltip.Builder builder = Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.API.transf("cycleindex", this.currentIndex(diagramState) + 1, this.components.size())).addSpacing().addTextLine(Lang.API.trans("cyclecomponents")).addAllDisplayComponents((Iterable<? extends DisplayComponent>)tooltipComponents);
        if (numComponents < this.components.size()) {
            builder.addTextLine(Lang.API.transf("excesscyclecomponents", this.components.size() - numComponents));
        }
        return builder.build();
    }

    @Override
    public Point position() {
        return this.position;
    }

    @Override
    public Dimension dimension() {
        return Dimension.create(16);
    }

    @Override
    public void interact(DiagramState diagramState, Interactable.RecipeType recipeType) {
        this.currentComponent(diagramState).interact(recipeType);
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.currentComponent(diagramState).draw(this.position);
    }

    @Override
    public void drawOverlay(DiagramState diagramState) {
        Draw.drawOverlay(this.position, -2130706433);
    }

    @Override
    public void drawTooltip(DiagramState diagramState, Point mousePos) {
        DisplayComponent component = this.currentComponent(diagramState);
        Tooltip itemStackTooltip = Tooltip.EMPTY_TOOLTIP;
        if (component.type() == Component.ComponentType.ITEM) {
            ItemStack stack = (ItemStack)component.stack();
            List lines = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            itemStackTooltip = Tooltip.builder().setFormatting(Tooltip.TRIVIAL_FORMATTING).addAllTextLines(lines.subList(1, lines.size())).build();
        }
        Tooltip.concat(component.descriptionTooltip(), this.slotTooltip, component.additionalTooltip(), itemStackTooltip, this.cycleTooltip(diagramState)).draw(mousePos);
    }
}

