/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.AllDiagramsButton;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Text;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.GregTechRecipeDebugger;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.LabelHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class LayoutFactory {
    static final ImmutableMap<GregTechRecipeDebugger.View, Point> VIEW_BUTTON_POSITIONS = ImmutableMap.builder().put((Object)GregTechRecipeDebugger.View.PROGRAMMED_CIRCUITS, (Object)Grid.GRID.grid(0, 2)).put((Object)GregTechRecipeDebugger.View.CONSUME_CIRCUIT_RECIPES, (Object)Grid.GRID.grid(2, 2)).put((Object)GregTechRecipeDebugger.View.UNNECESSARY_CIRCUIT_RECIPES, (Object)Grid.GRID.grid(4, 2)).put((Object)GregTechRecipeDebugger.View.COLLIDING_RECIPES, (Object)Grid.GRID.grid(6, 2)).put((Object)GregTechRecipeDebugger.View.VOIDING_RECIPES, (Object)Grid.GRID.grid(8, 2)).put((Object)GregTechRecipeDebugger.View.UNEQUAL_CELL_RECIPES, (Object)Grid.GRID.grid(10, 2)).put((Object)GregTechRecipeDebugger.View.SMALL_VARIANT_RECIPES, (Object)Grid.GRID.grid(12, 2)).put((Object)GregTechRecipeDebugger.View.BAD_CRAFTING_TABLE_RECIPES, (Object)Grid.GRID.grid(0, 4)).build();
    private final DiagramGroupInfo info;
    private final LabelHandler labelHandler;
    private CustomInteractable menuButton;

    LayoutFactory(DiagramGroupInfo info, LabelHandler labelHandler) {
        this.info = info;
        this.labelHandler = labelHandler;
    }

    void initialize() {
        this.menuButton = new AllDiagramsButton(this.info, Grid.GRID.grid(0, 0), Lang.GREGTECH_5_RECIPE_DEBUGGER.trans("menubutton"));
    }

    CustomInteractable menuButton() {
        return this.menuButton;
    }

    Layout buildMenuLayout(int totalRecipes) {
        return Layout.builder().addLabel(Text.builder(Lang.GREGTECH_5_RECIPE_DEBUGGER.transf("totalrecipecount", totalRecipes), Grid.GRID.grid(6, 0), Grid.Direction.C).build()).build();
    }

    Layout buildProgrammedCircuitsLayout() {
        return Layout.builder().addInteractable(this.menuButton).putSlotGroup(SlotGroupKeys.PROGRAMMED_CIRCUITS, SlotGroup.builder(5, 5, Grid.GRID.grid(6, 2), Grid.Direction.S).build()).build();
    }

    Layout buildRecipeLayout(int i, RecipeHandler.RecipeMap recipeMap) {
        Preconditions.checkArgument((i >= 0 && i < 3 ? 1 : 0) != 0, (String)"i not in range [0, %d): %d", (Object[])new Object[]{3, i});
        int y = 5 + i * 9;
        return Layout.builder().addLines(Lines.builder(Grid.GRID.grid(5, y)).addArrow(Grid.edge(Grid.GRID.grid(9, y), Grid.Direction.W)).build()).addInteractable(this.labelHandler.buildLabel(recipeMap, Grid.GRID.grid(7, y))).putSlotGroup((Layout.SlotGroupKey)SlotGroupKeys.RECIPE_INPUTS.get(i), SlotGroup.builder(4, 5, Grid.GRID.grid(5, y), Grid.Direction.W).build()).putSlotGroup((Layout.SlotGroupKey)SlotGroupKeys.RECIPE_OUTPUTS.get(i), SlotGroup.builder(3, 5, Grid.GRID.grid(9, y), Grid.Direction.E).build()).build();
    }

    static final class SlotGroupKeys {
        static final int RECIPES_PER_PAGE = 3;
        static final ImmutableList<Layout.SlotGroupKey> RECIPE_INPUTS = ImmutableList.copyOf((Collection)IntStream.range(0, 3).mapToObj(i -> Layout.SlotGroupKey.create("recipe-inputs-" + i)).collect(Collectors.toList()));
        static final ImmutableList<Layout.SlotGroupKey> RECIPE_OUTPUTS = ImmutableList.copyOf((Collection)IntStream.range(0, 3).mapToObj(i -> Layout.SlotGroupKey.create("recipe-outputs-" + i)).collect(Collectors.toList()));
        static final Layout.SlotGroupKey PROGRAMMED_CIRCUITS = Layout.SlotGroupKey.create("programmed-circuits");

        SlotGroupKeys() {
        }
    }
}

