/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen.retro;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import mantle.world.ChunkCoord;
import mods.natura.Natura;
import mods.natura.worldgen.BaseTreeWorldgen;
import mods.natura.worldgen.retro.TickHandlerWorld;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldHandler {
    private static HashSet dimensionBlacklist = new HashSet();
    private static long genHash = 100L;
    public static WorldHandler instance = new WorldHandler();

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (Natura.retrogen) {
            tag.func_74772_a("Features", genHash);
        }
        event.getData().func_74782_a("NaturaWorld", (NBTBase)tag);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.world.field_73011_w.field_76574_g;
        if (dimensionBlacklist.contains(dim)) {
            return;
        }
        boolean features = false;
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a("NaturaWorld");
        if (tag != null) {
            features = tag.func_74763_f("Features") != genHash && Natura.retrogen;
        }
        ChunkCoord cCoord = new ChunkCoord(event.getChunk());
        if (tag == null && Natura.retrogen && !event.getData().func_74767_n("Natura.Retrogen")) {
            regen = true;
        }
        if (features) {
            regen = true;
        }
        if (regen) {
            ArrayList chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            if (chunks == null) {
                TickHandlerWorld.chunksToGen.put(dim, new ArrayList());
                chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.add(cCoord);
                TickHandlerWorld.chunksToGen.put(dim, chunks);
            }
        }
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (newGen && !Natura.retrogen) {
            return;
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return;
        }
        Natura.crops.generate(random, chunkX, chunkZ, world, world.field_73011_w.func_76555_c(), world.field_73011_w.func_76555_c());
        Natura.clouds.generate(random, chunkX, chunkZ, world, world.field_73011_w.func_76555_c(), world.field_73011_w.func_76555_c());
        BaseTreeWorldgen.retrogen = true;
        Natura.trees.generate(random, chunkX, chunkZ, world, world.field_73011_w.func_76555_c(), world.field_73011_w.func_76555_c());
        BaseTreeWorldgen.retrogen = false;
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }
}

