/*
 * Decompiled with CFR 0.152.
 */
package shukaro.nodalmechanics.recipe;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import shukaro.nodalmechanics.items.NodalItems;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class RecipeNode
extends InfusionRecipe {
    private static final int ESSENTIA_MULTIPLIER = 4;
    private static final int INSTABILITY = 10;
    private final Random random = new Random();

    public RecipeNode() {
        super("NODECATALYZATION", (Object)ItemApi.getItem((String)"itemJarNode", (int)0), 10, new AspectList(), new ItemStack((Item)NodalItems.itemMatrix), new ItemStack[]{ItemApi.getItem((String)"itemResource", (int)14), ItemApi.getItem((String)"itemResource", (int)14), ItemApi.getItem((String)"itemResource", (int)14), ItemApi.getItem((String)"itemResource", (int)14)});
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.getResearch())) {
            return false;
        }
        ItemStack[] components = this.getComponents();
        if (input == null || input.size() != components.length) {
            return false;
        }
        for (int i = 0; i < components.length; ++i) {
            if (OreDictionary.itemMatches((ItemStack)components[i], (ItemStack)input.get(i), (boolean)true)) continue;
            return false;
        }
        if (central != null && central.func_77973_b().equals((Object)NodalItems.itemMatrix) && central.func_77942_o()) {
            AspectList nodeAspectList = new AspectList();
            nodeAspectList.readFromNBT(central.func_77978_p());
            if (nodeAspectList.size() == 0) {
                return false;
            }
            AspectList recipeAspectList = new AspectList();
            for (Aspect aspect : nodeAspectList.getAspects()) {
                recipeAspectList.add(aspect, nodeAspectList.getAmount(aspect) * 4);
            }
            this.aspects = recipeAspectList;
            NBTTagCompound tagCompound = new NBTTagCompound();
            nodeAspectList.writeToNBT(tagCompound);
            tagCompound.func_74768_a("nodetype", this.getNodeType());
            if (this.random.nextInt(100) < 75) {
                tagCompound.func_74768_a("nodemod", this.getNodeModifier());
            }
            ((ItemStack)this.recipeOutput).func_77982_d(tagCompound);
            return true;
        }
        return false;
    }

    private int getNodeType() {
        int chance = this.random.nextInt(100);
        if (chance < 75) {
            return NodeType.NORMAL.ordinal();
        }
        if (chance < 80) {
            return NodeType.UNSTABLE.ordinal();
        }
        if (chance < 85) {
            return NodeType.DARK.ordinal();
        }
        if (chance < 90) {
            return NodeType.TAINTED.ordinal();
        }
        if (chance < 95) {
            return NodeType.HUNGRY.ordinal();
        }
        return NodeType.PURE.ordinal();
    }

    private int getNodeModifier() {
        int chance = this.random.nextInt(100);
        if (chance < 75) {
            return NodeModifier.FADING.ordinal();
        }
        if (chance < 90) {
            return NodeModifier.PALE.ordinal();
        }
        return NodeModifier.BRIGHT.ordinal();
    }
}

