/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.container.slot.SlotRestrictedInput;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.github.vfyjxf.nee.container.ContainerPatternInterface;
import com.github.vfyjxf.nee.network.packet.PacketValueConfigClient;
import com.github.vfyjxf.nee.utils.GuiUtils;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class PacketValueConfigServer
implements IMessage {
    private String name;
    private String value;

    public PacketValueConfigServer() {
    }

    public PacketValueConfigServer(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public PacketValueConfigServer(String name) {
        this.name = name;
        this.value = "";
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.value = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.value);
    }

    public static final class Handler
    implements IMessageHandler<PacketValueConfigServer, IMessage> {
        public IMessage onMessage(PacketValueConfigServer message, MessageContext ctx) {
            IGrid grid;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if ("Container.selectedSlot".equals(message.name)) {
                if (container instanceof ContainerPatternInterface) {
                    ContainerPatternInterface cpc = (ContainerPatternInterface)container;
                    int slotIndex = Integer.parseInt(message.value);
                    Slot slot = container.func_75139_a(slotIndex);
                    if (slot instanceof SlotRestrictedInput) {
                        cpc.setSelectedSlotIndex(slot.field_75222_d);
                    }
                }
            } else if ("Gui.PatternInterface".equals(message.name)) {
                if (container instanceof ContainerPatternInterface) {
                    ContainerPatternInterface cpc = (ContainerPatternInterface)container;
                    TilePatternInterface tile = (TilePatternInterface)cpc.getTileEntity();
                    tile.cancelWork(cpc.getSelectedSlotIndex());
                    cpc.removeCurrentRecipe();
                    tile.updateCraftingList();
                }
            } else if ("PatternInterface.check".equals(message.name) && (grid = GuiUtils.getGrid(container)) != null) {
                for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                    if (!(gridNode.getMachine() instanceof TilePatternInterface)) continue;
                    return new PacketValueConfigClient("PatternInterface.check", true);
                }
                return new PacketValueConfigClient("PatternInterface.check", false);
            }
            return null;
        }
    }
}

