/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import com.bymarcin.openglasses.network.GlassesNetworkRegistry;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.network.packet.WidgetUpdatePacket;
import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class ServerSurface {
    public static ServerSurface instance = new ServerSurface();
    private final Map<UUID, Location> players = new HashMap<UUID, Location>();

    public void subscribePlayer(UUID playerUUID, Location UUID2, int width, int height) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = UUID2.getTerminal()) != null && terminal.getTerminalUUID().equals(UUID2)) {
            this.players.put(playerUUID, UUID2);
            this.sendSync((EntityPlayer)player, UUID2, terminal);
            this.sendPowerInfo(UUID2, terminal.isPowered() ? TerminalStatusPacket.TerminalStatus.HavePower : TerminalStatusPacket.TerminalStatus.NoPower);
            terminal.onGlassesPutOn(player.getDisplayName(), width, height);
        }
    }

    public void unsubscribePlayer(UUID playerUUID) {
        EntityPlayerMP player;
        OpenGlassesTerminalTileEntity terminal;
        Location l = this.players.remove(playerUUID);
        if (l != null && (terminal = l.getTerminal()) != null && (player = this.checkUUID(playerUUID)) != null) {
            terminal.onGlassesPutOff(player.getDisplayName());
        }
    }

    public void playerHudInteract(UUID playerUUID, int x, int y, int button, int type) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = this.players.get(playerUUID).getTerminal()) != null) {
            terminal.onHudInteract(player.getDisplayName(), x, y, button, type);
        }
    }

    public void playerHudKeyboardInteract(UUID playerUUID, char character, int key) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = this.players.get(playerUUID).getTerminal()) != null) {
            terminal.onHudInteractKeyboard(player.getDisplayName(), character, key);
        }
    }

    public void playerBlockInteract(UUID playerUUID, int x, int y, int z, int side) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = this.players.get(playerUUID).getTerminal()) != null) {
            terminal.onBlockInteract(player.getDisplayName(), x, y, z, side);
        }
    }

    public void overlayOpened(UUID playerUUID) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = this.players.get(playerUUID).getTerminal()) != null) {
            terminal.overlayOpened(player.getDisplayName());
        }
    }

    public void overlayClosed(UUID playerUUID) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = this.players.get(playerUUID).getTerminal()) != null) {
            terminal.overlayClosed(player.getDisplayName());
        }
    }

    public UUID[] getActivePlayers(Location l) {
        ArrayList<UUID> players = new ArrayList<UUID>();
        for (Map.Entry<UUID, Location> p : this.players.entrySet()) {
            if (!p.getValue().equals(l)) continue;
            players.add(p.getKey());
        }
        return players.toArray(new UUID[0]);
    }

    public String[] getActivePlayerNames(Location l) {
        ArrayList<String> players = new ArrayList<String>();
        for (Map.Entry<UUID, Location> p : this.players.entrySet()) {
            EntityPlayerMP player = this.checkUUID(p.getKey());
            if (!p.getValue().equals(l) || player == null) continue;
            players.add(player.func_146103_bH().getName());
        }
        return players.toArray(new String[0]);
    }

    public void sendSync(EntityPlayer p, Location coords, OpenGlassesTerminalTileEntity t) {
        WidgetUpdatePacket packet = new WidgetUpdatePacket(t.widgetList);
        GlassesNetworkRegistry.packetHandler.sendTo((IMessage)packet, (EntityPlayerMP)p);
    }

    public void sendPowerInfo(Location loc, TerminalStatusPacket.TerminalStatus status) {
        TerminalStatusPacket packet = new TerminalStatusPacket(status);
        this.sendToUUID(packet, loc);
    }

    public void sendToUUID(IMessage packet, Location UUID2) {
        Iterator<Map.Entry<UUID, Location>> it = this.players.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Location> e = it.next();
            EntityPlayerMP player = this.checkUUID(e.getKey());
            if (player == null) {
                it.remove();
                continue;
            }
            if (!e.getValue().equals(UUID2)) continue;
            GlassesNetworkRegistry.packetHandler.sendTo(packet, player);
        }
    }

    private EntityPlayerMP checkUUID(UUID uuid) {
        for (EntityPlayerMP p : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!p.func_146103_bH().getId().equals(uuid)) continue;
            return p;
        }
        return null;
    }
}

