/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.network.messages;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.util.PlayerUtil;

public class MessageModifyPermissions
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String player;
    private String perm;
    private boolean canDo;

    public MessageModifyPermissions() {
    }

    public MessageModifyPermissions(int x, int y, int z, String player, String perm, boolean canDo) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.player = player;
        this.perm = perm;
        this.canDo = canDo;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.player = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.perm = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.canDo = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.perm);
        buf.writeBoolean(this.canDo);
    }

    private int getX() {
        return this.x;
    }

    private int getY() {
        return this.y;
    }

    private int getZ() {
        return this.z;
    }

    private String getPlayer() {
        return this.player;
    }

    private String getPerm() {
        return this.perm;
    }

    public boolean getCanDo() {
        return this.canDo;
    }

    public static class MessageHandlerModifyPermissions
    implements IMessageHandler<MessageModifyPermissions, IMessage> {
        public IMessage onMessage(MessageModifyPermissions message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity entity = world.func_147438_o(message.getX(), message.getY(), message.getZ());
            TurretBase turret = null;
            if (entity instanceof TurretBase) {
                turret = (TurretBase)entity;
            }
            if (turret != null && PlayerUtil.isPlayerAdmin((EntityPlayer)player, turret)) {
                if (message.getPerm().equals("gui")) {
                    turret.getTrustedPlayer(message.getPlayer()).setCanOpenGUI(message.canDo);
                }
                if (message.getPerm().equals("targeting")) {
                    turret.getTrustedPlayer(message.getPlayer()).setCanChangeTargeting(message.canDo);
                }
                if (message.getPerm().equals("isAdmin")) {
                    turret.getTrustedPlayer(message.getPlayer()).setAdmin(message.canDo);
                }
            }
            return null;
        }
    }
}

