/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.mobiuscore.monitors;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.WeakHashMap;
import mcp.mobius.mobiuscore.asm.CoreDescription;
import mcp.mobius.mobiuscore.monitors.MonitoredList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class MonitoredTileList<E>
extends MonitoredList<E> {
    private static final long serialVersionUID = -2243048028307261560L;
    private Table<Block, Integer, Integer> count = HashBasedTable.create();
    private Map<Object, BlockData> blockdata = new WeakHashMap<Object, BlockData>();

    @Override
    protected void addCount(E e) {
        TileEntity te = (TileEntity)e;
        if (te == null || te.func_145831_w() == null) {
            return;
        }
        Block block = te.func_145831_w().func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int meta = te.func_145831_w().func_72805_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        this.blockdata.put(te, new BlockData(block, meta));
        try {
            this.count.put((Object)block, (Object)meta, (Object)((Integer)this.count.get((Object)block, (Object)meta) + 1));
        }
        catch (NullPointerException ex) {
            this.count.put((Object)block, (Object)meta, (Object)1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.count.put((Object)block, (Object)meta, (Object)1);
        }
    }

    @Override
    protected void removeCount(int index) {
        this.removeCount(this.get(index));
    }

    @Override
    protected void removeCount(Object o) {
        if (this.blockdata.containsKey(o)) {
            BlockData d = this.blockdata.get(o);
            try {
                this.count.put((Object)d.block, (Object)d.meta, (Object)((Integer)this.count.get((Object)d.block, (Object)d.meta) - 1));
            }
            catch (NullPointerException e) {
                this.count.put((Object)d.block, (Object)d.meta, (Object)0);
            }
        }
    }

    @Override
    protected void clearCount() {
        this.count.clear();
    }

    @Override
    public void printCount() {
        for (Table.Cell c : this.count.cellSet()) {
            CoreDescription.log.info(String.format("%s | %s : %s", c.getRowKey(), c.getColumnKey(), c.getValue()));
        }
    }

    public Table<Block, Integer, Integer> getCount() {
        return this.count;
    }

    private static class BlockData {
        public final Block block;
        public final int meta;

        public BlockData(Block b, int m) {
            this.block = b;
            this.meta = m;
        }
    }
}

