/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.BaseColorUtils;
import gcewing.projectblue.BaseGui;

public class BaseGuiColor {
    public static int colorForIndex(int i) {
        return BaseColorUtils.colors[i];
    }

    public static class ColorChooser
    extends BaseGui.Widget {
        protected static final int cellSize = 10;
        protected BaseGui.Ref target;

        public ColorChooser(BaseGui.Ref ref) {
            super(48, 58);
            this.target = ref;
        }

        @Override
        public void draw(BaseGui.Screen s, int mx, int my) {
            int sel = (Integer)this.target.get();
            if (sel < 0) {
                sel = 16;
            }
            s.drawGuiBackground(0.0, 0.0, this.width, this.height);
            for (int i = 0; i <= 16; ++i) {
                int x = 4 + (i & 3) * 10;
                int y = 4 + (i >> 2) * 10;
                if (i == sel) {
                    s.setColor(0x808080);
                    s.drawRect(x, y, 10.0, 10.0);
                }
                int c = i <= 15 ? BaseGuiColor.colorForIndex(i) : 0xA0A0A0;
                s.setColor(c);
                s.drawRect(x + 1, y + 1, 8.0, 8.0);
                if (i != 16) continue;
                s.drawCenteredString("x", x + 5, y + 1);
            }
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords m, int button) {
            int i;
            if (m.x < 0 || m.x >= this.width() || m.y < 0 || m.y >= this.height()) {
                this.close();
                return;
            }
            int col = (m.x - 4) / 10;
            int row = (m.y - 4) / 10;
            if (row >= 0 && row < 5 && col >= 0 && col < 4 && (i = row * 4 + col) <= 16) {
                if (i > 15) {
                    i = -1;
                }
                this.target.set(i);
                this.close();
            }
        }

        @Override
        public boolean keyPressed(char c, int key) {
            if (key == 1) {
                this.close();
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            this.removePopup();
        }
    }

    public static class ColorField
    extends BaseGui.Widget {
        protected BaseGui.Ref target;

        public ColorField(BaseGui.Ref ref) {
            super(8, 8);
            this.target = ref;
        }

        @Override
        public void draw(BaseGui.Screen s, int mx, int my) {
            s.setColor(0x606060);
            s.drawRect(-1.0, -1.0, this.width + 2, this.height + 2);
            int c = (Integer)this.target.get();
            if (c >= 0) {
                s.setColor(BaseGuiColor.colorForIndex(c));
                s.drawRect(0.0, 0.0, this.width, this.height);
            } else {
                s.setColor(0x808080);
                s.drawRect(0.0, 0.0, this.width, this.height);
                s.drawCenteredString("x", this.width / 2, 0);
            }
        }

        @Override
        public void mousePressed(BaseGui.MouseCoords m, int button) {
            ColorChooser chooser = new ColorChooser(this.target);
            this.addPopup(this.width + 2, -1, chooser);
        }
    }
}

