/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import gcewing.projectblue.ProjectBlue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public abstract class BaseNBTChannel<PACKET_TYPE extends Enum<?>> {
    EnumMap<Side, FMLEmbeddedChannel> channels;

    public BaseNBTChannel(String channelName) {
        NBTCodec codec = new NBTCodec();
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{codec});
        for (Side side : Side.values()) {
            ChannelPipeline pipe = this.channels.get(side).pipeline();
            pipe.removeLast();
            pipe.addLast(new ChannelHandler[]{new NBTHandler(this, side)});
        }
    }

    abstract Class<PACKET_TYPE> getPacketType();

    void onReceiveFromClient(PACKET_TYPE type, NBTTagCompound nbt, EntityPlayer player) {
    }

    void onReceiveFromServer(PACKET_TYPE type, NBTTagCompound nbt) {
    }

    void sendToTarget(PACKET_TYPE type, NBTTagCompound nbt, Side fromSide, FMLOutboundHandler.OutboundTarget target, Object ... args) {
        FMLEmbeddedChannel chan = this.channels.get(fromSide);
        NBTMessage msg = new NBTMessage();
        msg.type = type;
        msg.nbt = nbt;
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)target);
        if (args.length == 1) {
            chan.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(args[0]);
        }
        chan.writeAndFlush(msg).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(PACKET_TYPE type, NBTTagCompound nbt) {
        this.sendToTarget(type, nbt, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER, new Object[0]);
    }

    public void sendToPlayer(PACKET_TYPE type, NBTTagCompound nbt, EntityPlayer player) {
        this.sendToTarget(type, nbt, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, player);
    }

    public void sendToAllPlayers(PACKET_TYPE type, NBTTagCompound nbt) {
        this.sendToTarget(type, nbt, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALL, new Object[0]);
    }

    public void sendToAllAround(PACKET_TYPE type, NBTTagCompound nbt, NetworkRegistry.TargetPoint point) {
        this.sendToTarget(type, nbt, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, point);
    }

    public void sendToDimension(PACKET_TYPE type, NBTTagCompound nbt, int dimensionId) {
        this.sendToTarget(type, nbt, Side.SERVER, FMLOutboundHandler.OutboundTarget.DIMENSION, dimensionId);
    }

    private static class ValidatingObjectInputStream
    extends ObjectInputStream {
        private final Class<?> clazz;

        public ValidatingObjectInputStream(InputStream in, Class<?> clazz) throws IOException {
            super(in);
            this.clazz = clazz;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (!name.equals(this.clazz.getName()) && !name.equals("java.lang.Enum")) {
                ProjectBlue.logger.warn(ProjectBlue.securityMarker, "Received packet containing disallowed class: " + name);
                throw new RuntimeException();
            }
            return super.resolveClass(desc);
        }
    }

    static class NBTHandler<PACKET_TYPE extends Enum<?>>
    extends ChannelInboundHandlerAdapter {
        BaseNBTChannel<PACKET_TYPE> client;
        Side side;

        NBTHandler(BaseNBTChannel<PACKET_TYPE> client, Side side) {
            this.client = client;
            this.side = side;
        }

        public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
            if (obj instanceof NBTMessage) {
                NBTMessage msg = (NBTMessage)obj;
                switch (this.side) {
                    case SERVER: {
                        INetHandler net = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                        EntityPlayerMP player = ((NetHandlerPlayServer)net).field_147369_b;
                        this.client.onReceiveFromClient(msg.type, msg.nbt, (EntityPlayer)player);
                        break;
                    }
                    case CLIENT: {
                        this.client.onReceiveFromServer(msg.type, msg.nbt);
                    }
                }
            }
        }
    }

    class NBTCodec
    extends FMLIndexedMessageToMessageCodec<NBTMessage<PACKET_TYPE>> {
        NBTCodec() {
            this.addDiscriminator(0, NBTMessage.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, NBTMessage<PACKET_TYPE> msg, ByteBuf target) throws Exception {
            ByteBufOutputStream bytes = new ByteBufOutputStream(target);
            ObjectOutputStream stream = new ObjectOutputStream((OutputStream)bytes);
            stream.writeObject(msg.type);
            CompressedStreamTools.func_74800_a((NBTTagCompound)msg.nbt, (DataOutput)stream);
            stream.close();
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, NBTMessage<PACKET_TYPE> msg) {
            ByteBufInputStream bytes = new ByteBufInputStream(source);
            try {
                ValidatingObjectInputStream stream = new ValidatingObjectInputStream((InputStream)bytes, BaseNBTChannel.this.getPacketType());
                msg.type = (Enum)stream.readObject();
                msg.nbt = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(stream));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class NBTMessage<PACKET_TYPE extends Enum> {
        public PACKET_TYPE type;
        public NBTTagCompound nbt;
    }
}

