/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.PartMap;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gcewing.projectblue.PBFacePart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.libmc.PRLib;
import mrtjp.projectred.transmission.IRedwireEmitter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public abstract class PBWiredFacePart
extends PBFacePart
implements IConnectable,
IRedstonePart {
    public int connMap;

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("connMap", this.connMap);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.connMap = nbt.func_74762_e("connMap");
    }

    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            this.updateInternalConnections();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            this.updateExternalConnections();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().field_72995_K) {
            this.updateConnections();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            this.notifyNeighbors(15);
        }
    }

    protected void updateConnections() {
        this.updateInternalConnections();
        this.updateExternalConnections();
    }

    protected boolean updateExternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (this.connectStraight(r)) {
                newConn |= 16 << r;
                continue;
            }
            if (!this.connectCorner(r)) continue;
            newConn |= 1 << r;
        }
        if (newConn != (this.connMap & 0xF000FF)) {
            int diff = this.connMap ^ newConn;
            this.connMap = this.connMap & 0xFF0FFF00 | newConn;
            for (int r = 0; r < 4; ++r) {
                if ((diff & 1 << r) == 0) continue;
                this.notifyCornerChange(r);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int newConn = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.connectInternal(r)) continue;
            newConn |= 256 << r;
        }
        if (newConn != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | newConn;
            return true;
        }
        return false;
    }

    public boolean connectCorner(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        if (!this.world().func_147437_c(pos.x, pos.y, pos.z)) {
            int side1 = absDir ^ 1;
            int side2 = this.side;
            TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
            if (t != null && (t.partMap(side1) != null || t.partMap(side2) != null || t.partMap(PartMap.edgeBetween((int)side1, (int)side2)) != null)) {
                return false;
            }
        }
        pos.offset(this.side);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(absDir ^ 1)) instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            int r2 = Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1));
            return this.canConnectToGlobal(conn, r) && conn.canConnectCorner(r2) && conn.connectCorner((IConnectable)this, r2, -1);
        }
        return false;
    }

    public boolean connectStraight(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(this.side)) instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            return this.canConnectToGlobal(conn, r) && conn.connectStraight((IConnectable)this, (r + 2) % 4, -1);
        }
        return this.connectStraightOverride(absDir);
    }

    public boolean connectStraightOverride(int absDir) {
        return false;
    }

    public boolean connectInternal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        if (this.tile().partMap(PartMap.edgeBetween((int)absDir, (int)this.side)) != null) {
            return false;
        }
        TMultiPart tp = this.tile().partMap(absDir);
        if (tp instanceof IConnectable) {
            IConnectable conn = (IConnectable)tp;
            return this.canConnectToGlobal(conn, r) && conn.connectInternal((IConnectable)this, Rotation.rotationTo((int)absDir, (int)this.side));
        }
        return false;
    }

    public void notifyCornerChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset(this.side);
        this.world().func_147460_e(pos.x, pos.y, pos.z, this.tile().func_145838_q());
    }

    public void notifyStraightChange(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        this.world().func_147460_e(pos.x, pos.y, pos.z, this.tile().func_145838_q());
    }

    public void notifyNeighbors(int mask) {
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) != 0) {
                this.notifyCornerChange(r);
                continue;
            }
            if ((mask & 16 << r) == 0) continue;
            this.notifyStraightChange(r);
        }
    }

    public boolean connectCorner(IConnectable part, int r, int edgeSide) {
        if (this.canConnectToGlobal(part, r)) {
            this.connMap |= 1 << r;
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable part, int r, int edgeSide) {
        if (this.canConnectToGlobal(part, r)) {
            this.connMap |= 16 << r;
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable part, int r) {
        if (r < 0) {
            return false;
        }
        if (this.canConnectToGlobal(part, r)) {
            this.connMap |= 256 << r;
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int r) {
        return false;
    }

    public boolean canConnectToGlobal(IConnectable part, int r) {
        return this.canConnectTo(part, this.localEdge(r));
    }

    public int localEdge(int r) {
        return r + this.rot & 3;
    }

    public int globalEdge(int edge) {
        return edge - this.rot & 3;
    }

    public boolean canConnectTo(IConnectable part, int edge) {
        if (part instanceof IRedwireEmitter) {
            return this.canConnectToRedstone(edge);
        }
        return false;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        if ((side & 6) == (this.side & 6)) {
            return false;
        }
        return this.canConnectToRedstone(this.localEdgeForSide(side));
    }

    public boolean canConnectToRedstone(int edge) {
        return false;
    }

    private int localEdgeForSide(int side) {
        return this.localEdge(Rotation.rotationTo((int)this.side, (int)side));
    }

    public int getAllRedstoneInputs() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int signal = this.getRedstoneInput(i);
            if (signal <= result) continue;
            result = signal;
        }
        return result;
    }

    public int getRedstoneInput(int edge) {
        int r = this.globalEdge(edge);
        if ((this.connMap & 1 << r) != 0) {
            return this.calculateCornerSignal(r);
        }
        if ((this.connMap & 16 << r) != 0) {
            return this.calculateStraightSignal(r);
        }
        if ((this.connMap & 256 << r) != 0) {
            return this.calculateInternalSignal(r);
        }
        return this.calculateRedstoneSignal(r, this.requiresStrongInput(edge));
    }

    public boolean requiresStrongInput(int edge) {
        return false;
    }

    private int calculateRedstoneSignal(int r, boolean requiresStrong) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        int i = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
        if (i > 0 || requiresStrong) {
            return i;
        }
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        if (this.world().func_147445_c(pos.x, pos.y, pos.z, false)) {
            return this.world().func_94577_B(pos.x, pos.y, pos.z) * 17;
        }
        return 0;
    }

    private int calculateCornerSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir).offset(this.side);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1)));
        }
        return 0;
    }

    private int calculateStraightSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(absDir);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)this.world(), (BlockCoord)pos);
        if (t != null) {
            return this.getPartSignal(t.partMap(this.side), (r + 2) % 4);
        }
        return 0;
    }

    private int calculateInternalSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        TMultiPart tp = this.tile().partMap(absDir);
        int i = this.getPartSignal(tp, Rotation.rotationTo((int)absDir, (int)this.side));
        if (i > 0) {
            return i;
        }
        if (tp instanceof IRedstonePart) {
            IRedstonePart rp = (IRedstonePart)tp;
            return Math.max(rp.strongPowerLevel(this.side), rp.weakPowerLevel(this.side)) << 4;
        }
        return 0;
    }

    private int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        return 0;
    }
}

