/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue.mfr;

import gcewing.projectblue.BaseTileEntity;
import gcewing.projectblue.mfr.MFRIntegration;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.nbt.NBTTagCompound;

public class RednetAdaptorTE
extends BaseTileEntity
implements IBundledTile,
IBundledEmitter {
    public static final int DIRECTION_BIT = 1;
    public static final int CONNECTED_BIT = 2;
    public static final int BUNDLED_TO_REDNET = 0;
    public static final int REDNET_TO_BUNDLED = 1;
    byte[] bundledInput = new byte[16];
    byte[] bundledOutput = new byte[16];
    int[] rednetInput = new int[16];
    int[] rednetOutput = new int[16];
    int[] signalConfig = new int[16];

    public RednetAdaptorTE() {
        for (int i = 0; i < 8; ++i) {
            this.signalConfig[i] = 2;
            this.signalConfig[8 + i] = 3;
        }
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bundledInput")) {
            this.bundledInput = nbt.func_74770_j("bundledInput");
            this.bundledOutput = nbt.func_74770_j("bundledOutput");
            this.rednetInput = nbt.func_74759_k("rednetInput");
            this.rednetOutput = nbt.func_74759_k("rednetOutput");
            this.signalConfig = nbt.func_74759_k("signalConfig");
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbt) {
        nbt.func_74773_a("bundledInput", this.bundledInput);
        nbt.func_74773_a("bundledOutput", this.bundledOutput);
        nbt.func_74783_a("rednetInput", this.rednetInput);
        nbt.func_74783_a("rednetOutput", this.rednetOutput);
        nbt.func_74783_a("signalConfig", this.signalConfig);
    }

    public void toggleSignalDirection(int i) {
        int s = this.signalConfig[i];
        if ((s & 2) == 0) {
            this.setSignalConfig(i, s | 2);
        } else {
            this.setSignalConfig(i, s ^ 1);
        }
    }

    public void toggleSignalConnected(int i) {
        this.setSignalConfig(i, this.signalConfig[i] ^ 2);
    }

    public void setSignalConfig(int i, int state) {
        this.signalConfig[i] = state;
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void onNeighborBlockChange() {
        byte[] newInput = new byte[16];
        boolean changed = false;
        for (int side = 0; side < 6; ++side) {
            byte[] signal = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
            if (signal == null) continue;
            for (int i = 0; i < 16; ++i) {
                byte b = signal[i];
                if ((b & 0xFF) <= (newInput[i] & 0xFF)) continue;
                newInput[i] = b;
            }
        }
        for (int i = 0; i < 16; ++i) {
            if (this.bundledInput[i] == newInput[i]) continue;
            this.bundledInput[i] = newInput[i];
            changed = true;
        }
        if (changed) {
            this.transferSignals();
        }
        this.notifyNeighbours();
    }

    public void onRednetInputsChanged(int[] input) {
        for (int i = 0; i < 16; ++i) {
            this.rednetInput[i] = input[i];
        }
        this.transferSignals();
        this.notifyNeighbours();
    }

    void transferSignals() {
        block4: for (int i = 0; i < 16; ++i) {
            switch (this.signalConfig[i]) {
                case 2: {
                    this.rednetOutput[i] = this.bundledInput[i] != 0 ? 15 : 0;
                    continue block4;
                }
                case 3: {
                    this.bundledOutput[i] = (byte)(this.rednetInput[i] != 0 ? 255 : 0);
                    continue block4;
                }
                default: {
                    this.rednetOutput[i] = 0;
                    this.bundledOutput[i] = 0;
                }
            }
        }
        this.func_70296_d();
    }

    void notifyNeighbours() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, MFRIntegration.rednetAdaptorBlock);
    }

    void dumpSignal(byte[] signal) {
        for (byte i : signal) {
            System.out.printf(" %02x", i & 0xFF);
        }
        System.out.printf("\n", new Object[0]);
    }

    void dumpSignal(int[] signal) {
        for (int i : signal) {
            System.out.printf(" %02x", i);
        }
        System.out.printf("\n", new Object[0]);
    }

    public int[] getRednetOutput() {
        return this.rednetOutput;
    }

    public boolean canConnectBundled(int side) {
        return true;
    }

    public byte[] getBundledSignal(int dir) {
        return this.bundledOutput;
    }
}

