/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveModelRenderer;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LocomotiveRendererDefault
extends LocomotiveModelRenderer {
    protected final String modelTag;
    private final ModelBase model;
    private final ResourceLocation[] textures;
    private final int[] color = new int[3];
    protected final IIcon[] itemIcons = new IIcon[3];
    private float emblemSize = 0.15f;
    private float emblemOffsetX = 0.47f;
    private float emblemOffsetY = -0.17f;
    private float emblemOffsetZ = -0.515f;

    public LocomotiveRendererDefault(String rendererTag, String modelTag, ModelBase model) {
        this(rendererTag, modelTag, model, new ResourceLocation[]{new ResourceLocation("railcraft:textures/entities/locomotives/" + modelTag + ".primary.png"), new ResourceLocation("railcraft:textures/entities/locomotives/" + modelTag + ".secondary.png"), new ResourceLocation("railcraft:textures/entities/locomotives/" + modelTag + ".nocolor.png")});
    }

    public LocomotiveRendererDefault(String rendererTag, String modelTag, ModelBase model, ResourceLocation[] textures) {
        super(rendererTag);
        this.modelTag = modelTag;
        this.model = model;
        this.textures = textures;
        this.color[2] = 0xFFFFFF;
        this.setRenderItemIn3D(false);
    }

    public void setEmblemPosition(float size, float offsetX, float offsetY, float offsetZ) {
        this.emblemSize = size;
        this.emblemOffsetX = offsetX;
        this.emblemOffsetY = offsetY;
        this.emblemOffsetZ = offsetZ;
    }

    @Override
    public String getDisplayName() {
        return LocalizationPlugin.translate("railcraft." + this.modelTag + ".name");
    }

    @Override
    public IIcon[] getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public void registerItemIcons(IIconRegister iconRegister) {
        String tag = "railcraft:locomotives/" + MiscTools.cleanTag(this.modelTag);
        this.itemIcons[0] = iconRegister.func_94245_a(tag + ".primary");
        this.itemIcons[1] = iconRegister.func_94245_a(tag + ".secondary");
        this.itemIcons[2] = iconRegister.func_94245_a(tag + ".nocolor");
    }

    @Override
    public void renderLocomotive(IRenderer renderer, EntityMinecart cart, int primaryColor, int secondaryColor, ResourceLocation emblemTexture, float light, float time) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.color[0] = primaryColor;
        this.color[1] = secondaryColor;
        for (int pass = 0; pass < this.textures.length; ++pass) {
            renderer.bindTex(this.textures[pass]);
            int c = this.color[pass];
            float dim = 1.0f;
            float c1 = (float)(c >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(c >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(c & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * dim), (float)(c2 * dim), (float)(c3 * dim), (float)1.0f);
            this.model.func_78088_a((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glPopAttrib();
        if (emblemTexture != null) {
            renderer.bindTex(emblemTexture);
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            tess.func_78374_a((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY - this.emblemSize), (double)this.emblemOffsetZ, 0.0, 0.0);
            tess.func_78374_a((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)this.emblemOffsetZ, 0.0, 1.0);
            tess.func_78374_a((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)this.emblemOffsetZ, 1.0, 1.0);
            tess.func_78374_a((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + -this.emblemSize), (double)this.emblemOffsetZ, 1.0, 0.0);
            tess.func_78374_a((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + -this.emblemSize), (double)(-this.emblemOffsetZ), 0.0, 0.0);
            tess.func_78374_a((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)(-this.emblemOffsetZ), 0.0, 1.0);
            tess.func_78374_a((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)(-this.emblemOffsetZ), 1.0, 1.0);
            tess.func_78374_a((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY - this.emblemSize), (double)(-this.emblemOffsetZ), 1.0, 0.0);
            tess.func_78381_a();
        }
        GL11.glPopMatrix();
    }
}

