/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.delta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class TileCage
extends TileMachineBase {
    private boolean isOpen = false;
    private EntityLiving entity;
    private EntityLookHelper lookHelper;
    private EntityBodyHelper bodyHelper;
    private double lookX;
    private double lookZ;
    private Entity lookTarget;
    private int lookCounter;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineDelta.CAGE;
    }

    @Override
    public IIcon getIcon(int side) {
        if (side != 0 && side != 1 && this.isOpen) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        if (Game.isHost(this.field_145850_b)) {
            this.isOpen = !this.isOpen;
            this.sendUpdateToClient();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntity() {
        if (this.entity == null) {
            this.entity = (EntityLiving)EntityList.func_75620_a((String)"Chicken", (World)null);
            this.lookHelper = new EntityLookHelper(this.entity);
            this.bodyHelper = new EntityBodyHelper((EntityLivingBase)this.entity);
        }
        return this.entity;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b) && this.entity != null) {
            this.entity.func_70107_b(0.0, 0.0, 0.0);
            this.entity.field_70758_at = this.entity.field_70759_as;
            this.entity.field_70126_B = this.entity.field_70177_z;
            this.entity.field_70127_C = this.entity.field_70125_A;
            this.entity.field_70760_ar = this.entity.field_70761_aq;
            if (this.lookCounter > 0) {
                --this.lookCounter;
                if (this.lookTarget == null) {
                    this.lookHelper.func_75650_a(this.lookX, (double)this.entity.func_70047_e(), this.lookZ, 10.0f, (float)this.entity.func_70646_bf());
                } else {
                    this.lookHelper.func_75650_a(this.lookTarget.field_70165_t - ((double)this.field_145851_c + 0.5), this.lookTarget.field_70163_u - (double)((float)this.field_145848_d + this.entity.func_70047_e()), this.lookTarget.field_70161_v - ((double)this.field_145849_e + 0.5), 10.0f, (float)this.entity.func_70646_bf());
                }
            }
            this.lookHelper.func_75649_a();
            this.bodyHelper.func_75664_a();
            if (this.lookCounter <= 0) {
                this.lookTarget = null;
                if (this.entity.func_70681_au().nextDouble() < 0.1) {
                    List<EntityPlayer> nearby = MiscTools.getNearbyEntities(this.field_145850_b, EntityPlayer.class, this.field_145851_c, this.field_145848_d - 1, this.field_145848_d + 3, this.field_145849_e, 5.0f);
                    if (!nearby.isEmpty() && this.entity.func_70681_au().nextDouble() < 0.4) {
                        this.lookTarget = (Entity)nearby.get(MiscTools.RANDOM.nextInt(nearby.size()));
                        this.lookCounter = 60 + this.entity.func_70681_au().nextInt(60);
                    } else {
                        double d0 = Math.PI * 2 * this.entity.func_70681_au().nextDouble();
                        this.lookX = Math.cos(d0);
                        this.lookZ = Math.sin(d0);
                        this.lookCounter = 20 + this.entity.func_70681_au().nextInt(20);
                    }
                }
            }
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.isOpen);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean o = data.readBoolean();
        if (this.isOpen != o) {
            this.isOpen = o;
            this.markBlockForUpdate();
        }
    }
}

