/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserCart;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import mods.railcraft.common.blocks.machine.gamma.TileFluidLoader;
import mods.railcraft.common.blocks.machine.gamma.TileFluidUnloader;
import mods.railcraft.common.blocks.machine.gamma.TileItemLoader;
import mods.railcraft.common.blocks.machine.gamma.TileItemLoaderAdvanced;
import mods.railcraft.common.blocks.machine.gamma.TileItemUnloader;
import mods.railcraft.common.blocks.machine.gamma.TileItemUnloaderAdvanced;
import mods.railcraft.common.blocks.machine.gamma.TileRFLoader;
import mods.railcraft.common.blocks.machine.gamma.TileRFUnloader;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumMachineGamma implements IEnumMachine
{
    ITEM_LOADER(ModuleManager.Module.TRANSPORT, "loader.item", 0, TileItemLoader.class),
    ITEM_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.item", 0, TileItemUnloader.class),
    ITEM_LOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "loader.item.advanced", 0, TileItemLoaderAdvanced.class),
    ITEM_UNLOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "unloader.item.advanced", 0, TileItemUnloaderAdvanced.class),
    FLUID_LOADER(ModuleManager.Module.TRANSPORT, "loader.liquid", 2, TileFluidLoader.class),
    FLUID_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.liquid", 2, TileFluidUnloader.class),
    ENERGY_LOADER(ModuleManager.Module.IC2, "loader.energy", 0, TileEnergyLoader.class),
    ENERGY_UNLOADER(ModuleManager.Module.IC2, "unloader.energy", 0, TileEnergyUnloader.class),
    DISPENSER_CART(ModuleManager.Module.AUTOMATION, "dispenser.cart", 0, TileDispenserCart.class),
    DISPENSER_TRAIN(ModuleManager.Module.TRAIN, "dispenser.train", 0, TileDispenserTrain.class),
    RF_LOADER(ModuleManager.Module.REDSTONE_FLUX, "loader.rf", -1, TileRFLoader.class),
    RF_UNLOADER(ModuleManager.Module.REDSTONE_FLUX, "unloader.rf", -1, TileRFUnloader.class);

    private final ModuleManager.Module module;
    private final String tag;
    private final int extraIcons;
    private final Class<? extends TileMachineBase> tile;
    private IIcon[] texture;
    private static final List<EnumMachineGamma> creativeList;
    private static final EnumMachineGamma[] VALUES;
    public static final IIcon[] pipeTexture;
    private ToolTip tip;

    private EnumMachineGamma(ModuleManager.Module module, String tag, int extraIcons, Class<? extends TileMachineBase> tile) {
        this.module = module;
        this.tile = tile;
        this.tag = tag;
        this.extraIcons = extraIcons;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(IIcon ... tex) {
        this.texture = tex;
    }

    @Override
    public IIcon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (EnumMachineGamma machine : VALUES) {
            if (machine.extraIcons == -1) continue;
            machine.texture = new IIcon[machine.extraIcons + 6];
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, machine.extraIcons + 3);
            IIcon cap = icons[0];
            IIcon side = icons[1];
            IIcon face = icons[2];
            machine.texture[0] = cap;
            machine.texture[1] = cap;
            for (int i = 2; i < 6; ++i) {
                machine.texture[i] = side;
            }
            switch (machine) {
                case ITEM_LOADER: 
                case FLUID_LOADER: {
                    machine.texture[0] = face;
                    break;
                }
                case ITEM_UNLOADER: 
                case FLUID_UNLOADER: {
                    machine.texture[1] = face;
                    break;
                }
                default: {
                    machine.texture[3] = face;
                }
            }
            if (machine.extraIcons <= 0) continue;
            System.arraycopy(icons, 3, machine.texture, 6, machine.extraIcons);
        }
        IIcon emitterSide = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_LOADER.tag + ".side");
        EnumMachineGamma.RF_LOADER.texture = new IIcon[9];
        Arrays.fill(EnumMachineGamma.RF_LOADER.texture, emitterSide);
        EnumMachineGamma.RF_LOADER.texture[6] = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_LOADER.tag + ".side.unpowered");
        EnumMachineGamma.RF_LOADER.texture[3] = EnumMachineGamma.RF_LOADER.texture[7] = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_LOADER.tag + ".facing");
        EnumMachineGamma.RF_LOADER.texture[8] = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_LOADER.tag + ".facing.unpowered");
        emitterSide = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_UNLOADER.tag + ".side");
        EnumMachineGamma.RF_UNLOADER.texture = new IIcon[9];
        Arrays.fill(EnumMachineGamma.RF_UNLOADER.texture, emitterSide);
        EnumMachineGamma.RF_UNLOADER.texture[6] = EnumMachineGamma.RF_LOADER.texture[6];
        EnumMachineGamma.RF_UNLOADER.texture[3] = EnumMachineGamma.RF_UNLOADER.texture[7] = iconRegister.func_94245_a("railcraft:" + EnumMachineGamma.RF_UNLOADER.tag + ".facing");
        EnumMachineGamma.RF_UNLOADER.texture[8] = EnumMachineGamma.RF_LOADER.texture[8];
        IIcon[] pipe = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:loader.pipe", 2);
        EnumMachineGamma.pipeTexture[0] = pipe[0];
        EnumMachineGamma.pipeTexture[1] = pipe[0];
        for (int i = 2; i < 6; ++i) {
            EnumMachineGamma.pipeTexture[i] = pipe[1];
        }
    }

    public static EnumMachineGamma fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List<EnumMachineGamma> getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "tile.railcraft.machine.gamma." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    @Override
    public TileMachineBase getTileEntity() {
        try {
            return this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineGamma();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            return this.getBlock() != null;
        }
        return false;
    }

    @Override
    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = this.getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList<EnumMachineGamma>();
        VALUES = EnumMachineGamma.values();
        pipeTexture = new IIcon[6];
        creativeList.add(ITEM_LOADER);
        creativeList.add(ITEM_UNLOADER);
        creativeList.add(ITEM_LOADER_ADVANCED);
        creativeList.add(ITEM_UNLOADER_ADVANCED);
        creativeList.add(FLUID_LOADER);
        creativeList.add(FLUID_UNLOADER);
        creativeList.add(ENERGY_LOADER);
        creativeList.add(ENERGY_UNLOADER);
        creativeList.add(RF_LOADER);
        creativeList.add(RF_UNLOADER);
        creativeList.add(DISPENSER_CART);
        creativeList.add(DISPENSER_TRAIN);
    }
}

