/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.IRailcraftCart;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public abstract class CartContainerBase
extends EntityMinecartContainer
implements IRailcraftCart,
IItemCart {
    private final ForgeDirection[] travelDirectionHistory = new ForgeDirection[2];
    protected ForgeDirection travelDirection = ForgeDirection.UNKNOWN;
    protected ForgeDirection verticalTravelDirection = ForgeDirection.UNKNOWN;

    public CartContainerBase(World world) {
        super(world);
        this.field_70155_l = 4.0;
    }

    public CartContainerBase(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70155_l = 4.0;
    }

    public abstract ICartType getCartType();

    @Override
    public void initEntityFromItem(ItemStack stack) {
    }

    public final boolean func_130002_c(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        return this.doInteract(player);
    }

    public boolean doInteract(EntityPlayer player) {
        return true;
    }

    public double getDrag() {
        return 0.991999979019165;
    }

    public ItemStack getCartItem() {
        ItemStack stack = EnumCart.fromCart((EntityMinecart)this).getCartItem();
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_70005_c_());
        }
        return stack;
    }

    public abstract List<ItemStack> getItemsDropped();

    public String func_145825_b() {
        return LocalizationPlugin.translate(this.getCartType().getTag());
    }

    public void func_70106_y() {
        if (Game.isNotHost(this.field_70170_p)) {
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                this.func_70299_a(slot, null);
            }
        }
        super.func_70106_y();
    }

    public void func_94095_a(DamageSource par1DamageSource) {
        this.func_70106_y();
        List<ItemStack> drops = this.getItemsDropped();
        if (this.func_95999_t() != null) {
            drops.get(0).func_151001_c(this.func_95999_t());
        }
        for (ItemStack item : drops) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public int func_94087_l() {
        return -1;
    }

    protected void updateTravelDirection(int trackX, int trackY, int trackZ, int meta) {
        EnumTrackMeta trackMeta = EnumTrackMeta.fromMeta(meta);
        if (trackMeta != null) {
            ForgeDirection forgeDirection = this.determineTravelDirection(trackMeta);
            ForgeDirection previousForgeDirection = this.travelDirectionHistory[1];
            if (previousForgeDirection != ForgeDirection.UNKNOWN && this.travelDirectionHistory[0] == previousForgeDirection) {
                this.travelDirection = forgeDirection;
                this.verticalTravelDirection = this.determineVerticalTravelDirection(trackMeta);
            }
            this.travelDirectionHistory[0] = previousForgeDirection;
            this.travelDirectionHistory[1] = forgeDirection;
        }
    }

    private ForgeDirection determineTravelDirection(EnumTrackMeta trackMeta) {
        if (trackMeta.isStraightTrack()) {
            if (this.field_70165_t - this.field_70169_q > 0.0) {
                return ForgeDirection.EAST;
            }
            if (this.field_70165_t - this.field_70169_q < 0.0) {
                return ForgeDirection.WEST;
            }
            if (this.field_70161_v - this.field_70166_s > 0.0) {
                return ForgeDirection.SOUTH;
            }
            if (this.field_70161_v - this.field_70166_s < 0.0) {
                return ForgeDirection.NORTH;
            }
        } else {
            switch (trackMeta) {
                case EAST_SOUTH_CORNER: {
                    if (this.field_70166_s > this.field_70161_v) {
                        return ForgeDirection.EAST;
                    }
                    return ForgeDirection.SOUTH;
                }
                case WEST_SOUTH_CORNER: {
                    if (this.field_70166_s > this.field_70161_v) {
                        return ForgeDirection.WEST;
                    }
                    return ForgeDirection.SOUTH;
                }
                case WEST_NORTH_CORNER: {
                    if (this.field_70166_s > this.field_70161_v) {
                        return ForgeDirection.NORTH;
                    }
                    return ForgeDirection.WEST;
                }
                case EAST_NORTH_CORNER: {
                    if (this.field_70166_s > this.field_70161_v) {
                        return ForgeDirection.NORTH;
                    }
                    return ForgeDirection.EAST;
                }
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private ForgeDirection determineVerticalTravelDirection(EnumTrackMeta trackMeta) {
        if (trackMeta.isSlopeTrack()) {
            return this.field_70167_r < this.field_70163_u ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean canPassItemRequests() {
        return false;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return false;
    }
}

