/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.ItemBucketRailcraft;
import mods.railcraft.common.fluids.ItemFluidContainer;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FluidContainers {
    public static final FluidContainers INSTANCE = new FluidContainers();
    private static Item itemCreosoteOilBucket;
    private static Item itemCreosoteOilBottle;
    private static Item itemSteamBottle;
    private static ItemFluidContainer itemCreosoteOilCell;
    private static ItemFluidContainer itemCreosoteOilCan;
    private static ItemFluidContainer itemCreosoteOilWax;
    private static ItemFluidContainer itemCreosoteOilRefactory;

    private FluidContainers() {
    }

    public static ItemStack getCreosoteOilBucket() {
        Item item = itemCreosoteOilBucket;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.bucket";
            item = new ItemBucketRailcraft(Fluids.CREOSOTE.get());
            item.func_77655_b(tag);
            RailcraftRegistry.register(item);
            FluidHelper.registerBucket(Fluids.CREOSOTE.get(1000), new ItemStack(item));
            itemCreosoteOilBucket = item;
        }
        return new ItemStack(item);
    }

    public static ItemStack getCreosoteOilBottle() {
        return FluidContainers.getCreosoteOilBottle(1);
    }

    public static ItemStack getCreosoteOilBottle(int qty) {
        Item item = itemCreosoteOilBottle;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.bottle";
            if (RailcraftConfig.isItemEnabled(tag)) {
                item = new ItemFluidContainer().func_77655_b(tag).func_77637_a(CreativePlugin.RAILCRAFT_TAB);
                RailcraftRegistry.register(item);
                LootPlugin.addLootRailway(new ItemStack(item), 4, 16, "creosote.bottle");
                if (!RailcraftConfig.useCreosoteFurnaceRecipes() && RailcraftConfig.isSubBlockEnabled(EnumMachineAlpha.COKE_OVEN.getTag())) {
                    FluidHelper.registerBottle(Fluids.CREOSOTE.get(1000), new ItemStack(item));
                }
                itemCreosoteOilBottle = item;
            } else {
                return null;
            }
        }
        return new ItemStack(item, qty);
    }

    public static ItemStack getCreosoteOilCan() {
        return FluidContainers.getCreosoteOilCan(1);
    }

    public static ItemStack getCreosoteOilCan(int qty) {
        ItemFluidContainer item = itemCreosoteOilCan;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.can";
            if (RailcraftConfig.isItemEnabled(tag)) {
                item = new ItemFluidContainer();
                item.func_77655_b(tag);
                RailcraftRegistry.register(item);
                boolean forestry = FluidHelper.registerCan(Fluids.CREOSOTE.get(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
                }
                itemCreosoteOilCan = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilWax() {
        return FluidContainers.getCreosoteOilWax(1);
    }

    public static ItemStack getCreosoteOilWax(int qty) {
        ItemFluidContainer item = itemCreosoteOilWax;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.wax";
            if (RailcraftConfig.isItemEnabled(tag)) {
                item = new ItemFluidContainer();
                item.func_77655_b(tag);
                RailcraftRegistry.register(item);
                boolean forestry = FluidHelper.registerWax(Fluids.CREOSOTE.get(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
                }
                itemCreosoteOilWax = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilRefactory() {
        return FluidContainers.getCreosoteOilRefactory(1);
    }

    public static ItemStack getCreosoteOilRefactory(int qty) {
        ItemFluidContainer item = itemCreosoteOilRefactory;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.refactory";
            if (RailcraftConfig.isItemEnabled(tag)) {
                item = new ItemFluidContainer();
                item.func_77655_b(tag);
                RailcraftRegistry.register(item);
                boolean forestry = FluidHelper.registerRefactory(Fluids.CREOSOTE.get(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
                }
                itemCreosoteOilRefactory = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilCell() {
        return FluidContainers.getCreosoteOilCell(1);
    }

    public static ItemStack getCreosoteOilCell(int qty) {
        ItemFluidContainer item = itemCreosoteOilCell;
        if (item == null) {
            String tag = "railcraft.fluid.creosote.cell";
            if (RailcraftConfig.isItemEnabled(tag)) {
                item = new ItemFluidContainer();
                item.func_77655_b(tag);
                RailcraftRegistry.register(item);
                boolean ic2 = FluidHelper.registerCell(Fluids.CREOSOTE.get(1000), new ItemStack((Item)item));
                if (ic2) {
                    item.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
                }
                itemCreosoteOilCell = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getSteamBottle() {
        return FluidContainers.getSteamBottle(1);
    }

    public static ItemStack getSteamBottle(int qty) {
        Item item = itemSteamBottle;
        if (item == null) {
            String tag = "railcraft.fluid.steam.bottle";
            item = new ItemBucketRailcraft(Fluids.STEAM.get()).setContainerItemStack(new ItemStack(Items.field_151069_bo));
            item.func_77655_b(tag);
            RailcraftRegistry.register(item);
            FluidHelper.registerBottle(Fluids.STEAM.get(1000), new ItemStack(item));
            itemSteamBottle = item;
        }
        return new ItemStack(item);
    }
}

