/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.HashMap;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.tank.GenericMultiTankBase;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineEta;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineZeta;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.item.ItemStack;

public class ModuleAdvancedTanks
extends RailcraftModule {
    public static GenericMultiTankBase ALUMINIUM;
    public static GenericMultiTankBase STAINLESS;
    public static GenericMultiTankBase TITANIUM;
    public static GenericMultiTankBase TUNGSTENSTEEL;
    public static GenericMultiTankBase PALLADIUM;
    public static GenericMultiTankBase IRIDIUM;
    public static GenericMultiTankBase OSMIUM;
    public static GenericMultiTankBase NEUTRONIUM;
    public static final int CAPACITY_PER_BLOCK_ALUMINIUM = 64000;
    public static final int CAPACITY_PER_BLOCK_STAINLESS = 128000;
    public static final int CAPACITY_PER_BLOCK_TITANIUM = 256000;
    public static final int CAPACITY_PER_BLOCK_TUNGSTENSTEEL = 512000;
    public static final int CAPACITY_PER_BLOCK_PALLADIUM = 1024000;
    public static final int CAPACITY_PER_BLOCK_IRIDIUM = 0x177000;
    public static final int CAPACITY_PER_BLOCK_OSMIUM = 2048000;
    public static final int CAPACITY_PER_BLOCK_NEUTRONIUM = 0x2EE000;
    public static final HashMap<String, IEnumMachine> cacheTankType;
    public static final HashMap<String, GenericMultiTankBase> cacheTankMaterial;

    public static void initTanks() {
        ALUMINIUM = ModuleAdvancedTanks.createTank("aluminium", 64000, EnumMachineZeta.TANK_ALUMINIUM_WALL, EnumMachineZeta.TANK_ALUMINIUM_GAUGE, EnumMachineZeta.TANK_ALUMINIUM_VALVE);
        STAINLESS = ModuleAdvancedTanks.createTank("stainless", 128000, EnumMachineZeta.TANK_STAINLESS_WALL, EnumMachineZeta.TANK_STAINLESS_GAUGE, EnumMachineZeta.TANK_STAINLESS_VALVE);
        TITANIUM = ModuleAdvancedTanks.createTank("titanium", 256000, EnumMachineZeta.TANK_TITANIUM_WALL, EnumMachineZeta.TANK_TITANIUM_GAUGE, EnumMachineZeta.TANK_TITANIUM_VALVE);
        TUNGSTENSTEEL = ModuleAdvancedTanks.createTank("tungstensteel", 512000, EnumMachineZeta.TANK_TUNGSTENSTEEL_WALL, EnumMachineZeta.TANK_TUNGSTENSTEEL_GAUGE, EnumMachineZeta.TANK_TUNGSTENSTEEL_VALVE);
        PALLADIUM = ModuleAdvancedTanks.createTank("palladium", 1024000, EnumMachineZeta.TANK_PALLADIUM_WALL, EnumMachineZeta.TANK_PALLADIUM_GAUGE, EnumMachineZeta.TANK_PALLADIUM_VALVE);
        IRIDIUM = ModuleAdvancedTanks.createTank("iridium", 0x177000, EnumMachineEta.TANK_IRIDIUM_WALL, EnumMachineEta.TANK_IRIDIUM_GAUGE, EnumMachineEta.TANK_IRIDIUM_VALVE);
        OSMIUM = ModuleAdvancedTanks.createTank("osmium", 2048000, EnumMachineEta.TANK_OSMIUM_WALL, EnumMachineEta.TANK_OSMIUM_GAUGE, EnumMachineEta.TANK_OSMIUM_VALVE);
        NEUTRONIUM = ModuleAdvancedTanks.createTank("neutronium", 0x2EE000, EnumMachineEta.TANK_NEUTRONIUM_WALL, EnumMachineEta.TANK_NEUTRONIUM_GAUGE, EnumMachineEta.TANK_NEUTRONIUM_VALVE);
    }

    @Override
    public void initFirst() {
        ModuleAdvancedTanks.initTanks();
        this.initTankOfType(ALUMINIUM);
        this.initTankOfType(STAINLESS);
        this.initTankOfType(TITANIUM);
        this.initTankOfType(TUNGSTENSTEEL);
        this.initTankOfType(PALLADIUM);
        this.initTankOfType(IRIDIUM);
        this.initTankOfType(OSMIUM);
        this.initTankOfType(NEUTRONIUM);
    }

    private void initTankOfType(GenericMultiTankBase tankType) {
        this.defineTank(tankType.TANK_WALL, new Object[0]);
        this.defineTank(tankType.TANK_GAUGE, new Object[0]);
        this.defineTank(tankType.TANK_VALVE, new Object[0]);
    }

    private boolean defineTank(IEnumMachine type, Object ... recipe) {
        if (type instanceof EnumMachineZeta) {
            if (((EnumMachineZeta)type).register()) {
                this.addColorRecipes(type);
                return true;
            }
        } else if (type instanceof EnumMachineEta && ((EnumMachineEta)type).register()) {
            this.addColorRecipes(type);
            return true;
        }
        return false;
    }

    private void addColorRecipes(IEnumMachine type) {
        for (EnumColor color : EnumColor.VALUES) {
            ItemStack output = this.getColorTank(type, color, 8);
            CraftingPlugin.addShapedRecipe(output, "OOO", "ODO", "OOO", Character.valueOf('O'), type.getItem(), Character.valueOf('D'), color.getDye());
        }
    }

    private ItemStack getColorTank(IEnumMachine type, EnumColor color, int qty) {
        ItemStack stack = type.getItem(qty);
        return InvTools.setItemColor(stack, color);
    }

    private static GenericMultiTankBase createTank(String material, int capacity, IEnumMachine tankWall, IEnumMachine tankGauge, IEnumMachine tankValve) {
        GenericMultiTankBase tank = new GenericMultiTankBase(material, capacity, tankWall, tankValve, tankGauge);
        cacheTankMaterial.put(tankWall.getTag(), tank);
        cacheTankMaterial.put(tankGauge.getTag(), tank);
        cacheTankMaterial.put(tankValve.getTag(), tank);
        return tank;
    }

    static {
        cacheTankType = new HashMap();
        cacheTankMaterial = new HashMap();
    }
}

