/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public enum StackFilter implements IStackFilter
{
    ALL{

        @Override
        public boolean matches(ItemStack stack) {
            return true;
        }
    }
    ,
    FUEL{

        @Override
        public boolean matches(ItemStack stack) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
    }
    ,
    TRACK{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ITrackItem || stack.func_77973_b() instanceof ItemBlock && TrackTools.isRailBlock(((ItemBlock)stack.func_77973_b()).field_150939_a);
        }
    }
    ,
    MINECART{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemMinecart || stack.func_77973_b() instanceof IMinecartItem;
        }
    }
    ,
    BALLAST{

        @Override
        public boolean matches(ItemStack stack) {
            return BallastRegistry.isItemBallast(stack);
        }
    }
    ,
    EMPTY_BUCKET{

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.func_77973_b() == Items.field_151133_ar;
        }
    }
    ,
    FEED{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemFood || stack.func_77973_b() == Items.field_151015_O || stack.func_77973_b() instanceof ItemSeeds;
        }
    };


    public static void initialize() {
        for (StackFilter type : StackFilter.values()) {
            IStackFilter.filters.put(type.name(), type);
        }
    }

    @Override
    public abstract boolean matches(ItemStack var1);
}

