/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.List;
import java.util.Random;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentWorkshop
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;
    private boolean hasMadeChest;

    public ComponentWorkshop() {
    }

    public ComponentWorkshop(StructureVillagePieces.Start villagePiece, int par2, Random par3Random, StructureBoundingBox sbb, int coordBaseMode) {
        this.field_74885_f = coordBaseMode;
        this.field_74887_e = sbb;
    }

    public static ComponentWorkshop buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
        StructureBoundingBox box = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)6, (int)11, (int)coordBaseMode);
        return ComponentWorkshop.func_74895_a((StructureBoundingBox)box) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)box) == null ? new ComponentWorkshop(villagePiece, p5, random, box, coordBaseMode) : null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        int l;
        int k;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 4, 0);
        }
        int x = this.field_74887_e.field_78897_a;
        int y = this.field_74887_e.field_78895_b;
        int z = this.field_74887_e.field_78896_c;
        this.func_151549_a(world, sbb, 1, 1, 2, 3, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151549_a(world, sbb, 5, 1, 0, 9, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151549_a(world, sbb, 4, 0, 0, 10, 0, 10, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
        this.func_151549_a(world, sbb, 0, 0, 1, 3, 0, 5, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
        this.func_151549_a(world, sbb, 7, 1, 2, 7, 1, 8, Blocks.field_150448_aq, Blocks.field_150448_aq, false);
        this.placeTrack(EnumTrack.BUFFER_STOP, world, 7, 1, 1, sbb, EnumTrackMeta.NORTH_SOUTH.ordinal(), false);
        this.placeTrack(EnumTrack.BUFFER_STOP, world, 7, 1, 9, sbb, EnumTrackMeta.NORTH_SOUTH.ordinal(), true);
        this.func_151549_a(world, sbb, 4, 0, 0, 4, 3, 10, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 10, 0, 0, 10, 3, 10, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 5, 0, 0, 5, 4, 0, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 9, 0, 0, 9, 4, 0, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 5, 0, 10, 5, 4, 10, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 9, 0, 10, 9, 4, 10, Blocks.field_150336_V, Blocks.field_150336_V, false);
        int metaRoofSupportA = this.func_151555_a(Blocks.field_150446_ar, 1) | 4;
        int metaRoofSupportB = this.func_151555_a(Blocks.field_150446_ar, 0) | 4;
        for (int rz = 1; rz <= 9; ++rz) {
            this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportA, 5, 4, rz, sbb);
            this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportB, 9, 4, rz, sbb);
        }
        this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportA, 6, 4, 0, sbb);
        this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportB, 8, 4, 0, sbb);
        this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportA, 6, 4, 10, sbb);
        this.func_151550_a(world, Blocks.field_150389_bf, metaRoofSupportB, 8, 4, 10, sbb);
        this.func_151549_a(world, sbb, 10, 2, 2, 10, 2, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        this.func_151549_a(world, sbb, 10, 2, 7, 10, 2, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        this.func_151549_a(world, sbb, 4, 2, 7, 4, 2, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        int metaHallRoofA = this.func_151555_a(Blocks.field_150446_ar, 0);
        int metaHallRoofB = this.func_151555_a(Blocks.field_150446_ar, 1);
        for (int rz = 0; rz <= 10; ++rz) {
            this.func_151550_a(world, Blocks.field_150390_bg, metaHallRoofA, 4, 4, rz, sbb);
            this.func_151550_a(world, Blocks.field_150390_bg, metaHallRoofB, 10, 4, rz, sbb);
            this.func_151550_a(world, Blocks.field_150390_bg, metaHallRoofA, 5, 5, rz, sbb);
            this.func_151550_a(world, Blocks.field_150390_bg, metaHallRoofB, 9, 5, rz, sbb);
        }
        this.func_151549_a(world, sbb, 6, 5, 0, 8, 5, 10, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
        this.func_151556_a(world, sbb, 6, 5, 1, 8, 5, 9, Blocks.field_150417_aV, 2, Blocks.field_150417_aV, 2, false);
        this.func_151556_a(world, sbb, 7, 5, 2, 7, 5, 8, Blocks.field_150417_aV, 1, Blocks.field_150417_aV, 1, false);
        this.func_151550_a(world, (Block)Blocks.field_150399_cn, 9, 7, 5, 2, sbb);
        this.func_151550_a(world, (Block)Blocks.field_150399_cn, 9, 7, 5, 5, sbb);
        this.func_151550_a(world, (Block)Blocks.field_150399_cn, 9, 7, 5, 8, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 9, 3, 1, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 9, 3, 5, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 9, 3, 9, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 1, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 5, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 9, sbb);
        this.func_151549_a(world, sbb, 0, 0, 1, 0, 3, 5, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 1, 0, 1, 3, 3, 1, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 1, 0, 5, 3, 3, 5, Blocks.field_150336_V, Blocks.field_150336_V, false);
        this.func_151549_a(world, sbb, 1, 4, 2, 4, 4, 4, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
        int metaHutRoofA = this.func_151555_a(Blocks.field_150446_ar, 0);
        for (int rz = 1; rz <= 5; ++rz) {
            this.func_151550_a(world, Blocks.field_150390_bg, metaHutRoofA, 0, 4, rz, sbb);
        }
        int metaHutRoofB = this.func_151555_a(Blocks.field_150446_ar, 3);
        int metaHutRoofC = this.func_151555_a(Blocks.field_150446_ar, 2);
        for (int rx = 1; rx <= 3; ++rx) {
            this.func_151550_a(world, Blocks.field_150390_bg, metaHutRoofB, rx, 4, 1, sbb);
            this.func_151550_a(world, Blocks.field_150390_bg, metaHutRoofC, rx, 4, 5, sbb);
        }
        this.func_151549_a(world, sbb, 4, 1, 3, 4, 2, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151549_a(world, sbb, 4, 1, 3, 4, 2, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151550_a(world, (Block)Blocks.field_150334_T, 0, 4, 0, 3, sbb);
        this.func_74881_a(world, this.field_74887_e, random, 4, 1, 3, 2);
        this.func_151549_a(world, sbb, 2, 2, 1, 2, 2, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        this.func_151549_a(world, sbb, 2, 2, 5, 2, 2, 5, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        this.func_151549_a(world, sbb, 0, 2, 3, 0, 2, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 2, sbb);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 4, sbb);
        if (EnumMachineAlpha.ROLLING_MACHINE.isAvaliable()) {
            this.func_151550_a(world, RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.ROLLING_MACHINE.ordinal(), 9, 1, 5, sbb);
            if (EnumMachineBeta.ENGINE_STEAM_HOBBY.isAvaliable() && RailcraftConfig.machinesRequirePower()) {
                this.placeEngine(world, 9, 1, 6, sbb);
            }
        }
        for (k = 0; k < 11; ++k) {
            for (l = 4; l < 11; ++l) {
                this.func_74871_b(world, l, 6, k, sbb);
                this.func_151554_b(world, Blocks.field_150347_e, 0, l, -1, k, sbb);
            }
        }
        for (k = 1; k < 6; ++k) {
            for (l = 0; l < 4; ++l) {
                this.func_74871_b(world, l, 6, k, sbb);
                this.func_151554_b(world, Blocks.field_150347_e, 0, l, -1, k, sbb);
            }
        }
        this.placeChest(world, 9, 1, 4, 3, random, sbb);
        this.func_74893_a(world, sbb, 0, 0, 0, 2);
        return true;
    }

    protected int func_74888_b(int par1) {
        return 456;
    }

    private void placeTrack(EnumTrack track, World world, int x, int y, int z, StructureBoundingBox sbb, int meta, boolean reversed) {
        int zz;
        int yy;
        if (!track.isEnabled()) {
            this.func_151550_a(world, Blocks.field_150448_aq, 0, x, y, z, sbb);
            return;
        }
        int xx = this.func_74865_a(x, z);
        if (!sbb.func_78890_b(xx, yy = this.func_74862_a(y), zz = this.func_74873_b(x, z))) {
            return;
        }
        TileTrack tile = TrackTools.placeTrack(track.getTrackSpec(), world, xx, yy, zz, meta);
        boolean r = false;
        switch (this.field_74885_f) {
            case 0: 
            case 1: {
                r = false;
                break;
            }
            case 2: 
            case 3: {
                r = true;
            }
        }
        ((ITrackReversable)tile.getTrackInstance()).setReversed(r != reversed);
    }

    private void placeEngine(World world, int x, int y, int z, StructureBoundingBox sbb) {
        int zz;
        int yy;
        int xx = this.func_74865_a(x, z);
        if (!sbb.func_78890_b(xx, yy = this.func_74862_a(y), zz = this.func_74873_b(x, z))) {
            return;
        }
        WorldPlugin.setBlock(world, xx, yy, zz, RailcraftBlocks.getBlockMachineBeta(), EnumMachineBeta.ENGINE_STEAM_HOBBY.ordinal());
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, xx, yy, zz);
        if (tile instanceof TileEngineSteamHobby) {
            TileEngineSteamHobby engine = (TileEngineSteamHobby)tile;
            engine.switchOrientation();
            engine.fill(ForgeDirection.UP, Fluids.WATER.getB(4), true);
        }
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        super.func_143012_a(nbt);
        nbt.func_74757_a("Chest", this.hasMadeChest);
    }

    protected void func_143011_b(NBTTagCompound nbt) {
        super.func_143011_b(nbt);
        this.hasMadeChest = nbt.func_74767_n("Chest");
    }

    private void placeChest(World world, int x, int y, int z, int meta, Random rand, StructureBoundingBox sbb) {
        int xx = this.func_74865_a(x, z);
        int yy = this.func_74862_a(y);
        int zz = this.func_74873_b(x, z);
        if (!this.hasMadeChest && sbb.func_78890_b(xx, yy, zz)) {
            this.hasMadeChest = true;
            if (world.func_147439_a(xx, yy, zz) != Blocks.field_150486_ae) {
                world.func_147465_d(xx, yy, zz, (Block)Blocks.field_150486_ae, this.func_151555_a((Block)Blocks.field_150486_ae, meta), 2);
                TileEntityChest chest = (TileEntityChest)world.func_147438_o(xx, yy, zz);
                if (chest != null) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"railcraft:workshop", (Random)rand), (IInventory)chest, (int)ChestGenHooks.getCount((String)"railcraft:workshop", (Random)rand));
                }
            }
        }
    }
}

