/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tile;

import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IHeatSource;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import remoteio.common.RemoteIO;
import remoteio.common.tile.core.TileCore;

@Optional.Interface(iface="ic2.api.energy.tile.IHeatSource", modid="IC2")
public class TileMachineHeater
extends TileCore
implements IHeatSource {
    public boolean filled = false;
    public int heatUsed = 0;

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("filled", this.filled);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.filled = nbt.func_74767_n("filled");
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.heatUsed = 0;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.update();
                if (this.filled) {
                    this.push();
                }
            }
        }
    }

    @Override
    public void onNeighborUpdated() {
        this.update();
    }

    private void update() {
        boolean newFilled;
        int found = 0;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            if (block == null || block != Blocks.field_150353_l && block != Blocks.field_150356_k) continue;
            ++found;
        }
        boolean bl = newFilled = found >= 2;
        if (this.filled != newFilled) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.filled = newFilled;
    }

    private void push() {
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            if (!(tileEntity instanceof TileEntityFurnace)) continue;
            ((TileEntityFurnace)tileEntity).field_145956_a = 200;
            if (tileEntity.func_145838_q() != Blocks.field_150460_al) continue;
            BlockFurnace.func_149931_a((boolean)true, (World)this.field_145850_b, (int)(this.field_145851_c + forgeDirection.offsetX), (int)(this.field_145848_d + forgeDirection.offsetY), (int)(this.field_145849_e + forgeDirection.offsetZ));
        }
    }

    @Optional.Method(modid="IC2")
    public int maxrequestHeatTick(ForgeDirection directionFrom) {
        return 1;
    }

    @Optional.Method(modid="IC2")
    public int requestHeat(ForgeDirection directionFrom, int requestedHeat) {
        if (!this.filled) {
            return 0;
        }
        int used = Math.min(RemoteIO.heatProvided - this.heatUsed, requestedHeat);
        this.heatUsed += used;
        return used;
    }
}

