/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis.widgets;

import gcewing.sg.SGAddressing;
import gcewing.sg.SGCraft;
import gcewing.sg.guis.screens.DHDScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DHDSymbolButton
extends GuiButton {
    public static final double ANGLE = 18.94736842105263;
    private static final double OUTER_UPPER_LIMIT = 7744.0;
    private static final double OUTER_LOWER_LIMIT = 3969.0;
    private static final double INNER_UPPER_LIMIT = 3721.0;
    private static final double INNER_LOWER_LIMIT = 1089.0;
    private static final ResourceLocation[] Textures = new ResourceLocation[]{SGCraft.mod.resourceLocation("textures/gui/dhd/classic_dhd_outer_buttons_1.png"), SGCraft.mod.resourceLocation("textures/gui/dhd/classic_dhd_outer_buttons_2.png"), SGCraft.mod.resourceLocation("textures/gui/dhd/classic_dhd_inner_buttons.png")};
    private final DHDScreen dhdScreen;
    private final int textureIndex;
    private final int symbol;
    private final double angle;
    private final double upperLimit;
    private final double lowerLimit;
    private final int u;
    private final int v;

    public DHDSymbolButton(int id, int x, int y, int u, int v, int width, int height, int symbol, boolean outer, int textureIndex, DHDScreen dhdScreen) {
        super(id, x, y, width, height, "");
        this.symbol = symbol;
        this.dhdScreen = dhdScreen;
        this.upperLimit = outer ? 7744.0 : 3721.0;
        double d = this.lowerLimit = outer ? 3969.0 : 1089.0;
        if (symbol > 36) {
            this.field_146124_l = false;
            this.field_146126_j = "#";
            this.angle = 0.0;
        } else {
            this.angle = ((double)((this.symbol - 1) % 19) * 18.94736842105263 + 270.0) % 360.0;
            this.field_146126_j = String.valueOf(SGAddressing.symbolToChar(symbol - 1));
        }
        this.u = u;
        this.v = v;
        if (textureIndex > 2 || textureIndex < 0) {
            throw new RuntimeException();
        }
        this.textureIndex = textureIndex;
    }

    private boolean check(int mouseX, int mouseY) {
        double phi = -Math.toDegrees(Math.atan2(mouseX - this.dhdScreen.centreX, mouseY - this.dhdScreen.centreY)) + 180.0;
        if (phi > this.angle && phi < this.angle + 18.94736842105263) {
            double distance = Math.pow(mouseX - this.dhdScreen.centreX, 2.0) + Math.pow(mouseY - this.dhdScreen.centreY, 2.0);
            return distance >= this.lowerLimit && distance <= this.upperLimit;
        }
        return false;
    }

    public int getHoverState(int mouseX, int mouseY) {
        if (this.field_146124_l && this.field_146125_m) {
            if (this.dhdScreen.getEnteredAddress().contains(this.field_146126_j)) {
                return 2;
            }
            if (this.check(mouseX, mouseY)) {
                return 1;
            }
        }
        return 0;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(Textures[this.textureIndex]);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k = this.getHoverState(mouseX, mouseY);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, this.u, this.v + k * this.field_146121_g, this.field_146120_f, this.field_146121_g);
            int l = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                l = this.packedFGColour;
            } else if (!this.field_146124_l) {
                l = 0xA0A0A0;
            } else if (this.field_146123_n) {
                l = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (this.check(mouseX, mouseY)) {
            this.dhdScreen.dhdButtonPressed(this.symbol);
            return true;
        }
        return false;
    }
}

