/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.packets;

import gcewing.sg.SGCraft;
import gcewing.sg.guis.DHDTE;
import gcewing.sg.interfaces.ChannelInput;
import gcewing.sg.interfaces.ChannelOutput;
import gcewing.sg.packets.BaseDataChannel;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.BaseUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.joml.Vector3i;

public class SGChannel
extends BaseDataChannel {
    protected static BaseDataChannel channel;

    public SGChannel(String name) {
        super(name, new Object[0]);
        channel = this;
    }

    public static void sendConnectOrDisconnectToServer(SGBaseTE te, String address) {
        ChannelOutput data = channel.openServer("ConnectOrDisconnect");
        SGChannel.writeCoords(data, te);
        data.writeUTF(address);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="ConnectOrDisconnect")
    public void handleConnectOrDisconnectFromClient(EntityPlayer player, ChannelInput data) {
        Vector3i pos = this.readCoords(data);
        String address = data.readUTF();
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        SGCraft.log.debug(String.format("SGChannel.handleConnectOrDisconnectFromClient: %s %s %s", pos, address, te));
        if (te != null) {
            te.connectOrDisconnect(address, player);
        }
    }

    public static void sendEnteredAddressToServer(DHDTE te, String address) {
        ChannelOutput data = channel.openServer("EnteredAddress");
        SGChannel.writeCoords(data, te);
        data.writeUTF(address);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="EnteredAddress")
    public void handleEnteredAddressFromClient(EntityPlayer player, ChannelInput data) {
        Vector3i pos = this.readCoords(data);
        String address = data.readUTF();
        DHDTE te = DHDTE.at((IBlockAccess)player.field_70170_p, pos);
        if (te != null) {
            te.setEnteredAddress(address);
        }
    }

    public static void writeCoords(ChannelOutput data, TileEntity te) {
        BaseUtils.writeBlockPos(data, BaseBlockUtils.getTileEntityPos(te));
    }

    public Vector3i readCoords(ChannelInput data) {
        return BaseUtils.readBlockPos(data);
    }
}

