/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentities;

import gcewing.sg.SGCraft;
import gcewing.sg.interfaces.IBlock;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.ITickable;
import gcewing.sg.interfaces.ITileEntity;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.BaseUtils;
import gcewing.sg.utils.Trans3;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class BaseTileEntity
extends TileEntity
implements ITileEntity {
    public byte side;
    public byte turn;
    public ForgeChunkManager.Ticket chunkTicket;
    protected boolean updateChunk;
    protected static Method getOrCreateChunkWatcher = BaseUtils.getMethodDef(PlayerManager.class, "getOrCreateChunkWatcher", "func_72690_a", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
    protected static Field flagsYAreasToUpdate = BaseUtils.getFieldDef(BaseUtils.classForName("net.minecraft.server.management.PlayerManager$PlayerInstance"), "flagsYAreasToUpdate", "field_73260_f");

    public Vector3i getPos() {
        return new Vector3i(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    public void setSide(int side) {
        this.side = (byte)side;
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(new Vector3d(0.5 + (double)this.field_145851_c, 0.5 + (double)this.field_145848_d, 0.5 + (double)this.field_145849_e));
    }

    public Trans3 localToGlobalTransformation(Vector3d origin) {
        Vector3i pos = this.getPos();
        IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)this.field_145850_b, pos);
        Block block = state.getBlock();
        if (block instanceof IBlock) {
            return ((IBlock)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, pos, state, origin);
        }
        SGCraft.log.debug(String.format("BaseTileEntity.localToGlobalTransformation: Wrong block type at %s", pos));
        return new Trans3(origin);
    }

    public Packet func_145844_m() {
        if (!this.syncWithClient()) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        super.func_145841_b(nbt);
        this.writeClientStateToNBT(nbt);
        if (this.updateChunk) {
            nbt.func_74757_a("updateChunk", true);
            this.updateChunk = false;
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        super.func_145839_a(nbt);
        this.readClientStateFromNBT(nbt);
        if (nbt.func_74767_n("updateChunk")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.updateChunk = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void markForUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        PlayerManager pm = ((WorldServer)this.field_145850_b).func_73040_p();
        Object watcher = BaseUtils.invokeMethod(pm, getOrCreateChunkWatcher, this.field_145851_c >> 4, this.field_145849_e >> 4, false);
        if (watcher == null) {
            return;
        }
        int oldFlags = BaseUtils.getIntField(watcher, flagsYAreasToUpdate);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        BaseUtils.setIntField(watcher, flagsYAreasToUpdate, oldFlags);
    }

    public void playSoundEffect(String name, float volume, float pitch) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, name, volume, pitch);
    }

    @Override
    public void onAddedToWorld() {
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readPersistentStateFromNBT(nbt);
    }

    protected void readPersistentStateFromNBT(NBTTagCompound nbt) {
        this.side = nbt.func_74771_c("side");
        this.turn = nbt.func_74771_c("turn");
        this.readContentsFromNBT(nbt);
    }

    protected void readClientStateFromNBT(NBTTagCompound nbt) {
        this.readPersistentStateFromNBT(nbt);
    }

    public void readContentsFromNBT(NBTTagCompound nbt) {
    }

    public final void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writePersistentStateToNBT(nbt);
    }

    protected void writePersistentStateToNBT(NBTTagCompound nbt) {
        if (this.side != 0) {
            nbt.func_74774_a("side", this.side);
        }
        if (this.turn != 0) {
            nbt.func_74774_a("turn", this.turn);
        }
        this.writeContentsToNBT(nbt);
    }

    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeContentsToNBT(nbt);
    }

    protected void writeClientStateToNBT(NBTTagCompound nbt) {
        this.writePersistentStateToNBT(nbt);
    }

    public void writeContentsToNBT(NBTTagCompound nbt) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public void markBlockChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public boolean canUpdate() {
        return this instanceof ITickable;
    }

    public void func_145845_h() {
        ((ITickable)((Object)this)).update();
    }
}

