/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.network.message;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.network.message.MessageDownloadBeginAck;
import com.github.lunatrius.schematica.world.storage.Schematic;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class MessageDownloadBegin
implements IMessage,
IMessageHandler<MessageDownloadBegin, IMessage> {
    public ItemStack icon;
    public int width;
    public int height;
    public int length;

    public MessageDownloadBegin() {
    }

    public MessageDownloadBegin(ISchematic schematic) {
        this.icon = schematic.getIcon();
        this.width = schematic.getWidth();
        this.height = schematic.getHeight();
        this.length = schematic.getLength();
    }

    public void fromBytes(ByteBuf buf) {
        this.icon = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.width = buf.readShort();
        this.height = buf.readShort();
        this.length = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.icon);
        buf.writeShort(this.width);
        buf.writeShort(this.height);
        buf.writeShort(this.length);
    }

    public IMessage onMessage(MessageDownloadBegin message, MessageContext ctx) {
        DownloadHandler.INSTANCE.schematic = new Schematic(message.icon, message.width, message.height, message.length);
        return new MessageDownloadBeginAck();
    }
}

