/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraftforge.client.event.GuiScreenEvent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.ButtonContainer;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.compression.ICompress;
import serverutils.lib.util.misc.MouseButton;
import serverutils.task.backup.BackupTask;

@EventBusSubscriber(side={Side.CLIENT})
public class GuiRestoreBackup
extends GuiButtonListBase {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final Set<File> allBackupFiles = new ObjectOpenHashSet();
    private static Object2ObjectMap<String, List<File>> worldBackups;
    private final List<File> backupFiles;
    private final String title;
    private final Button backButton;
    private final Button recreateWorldButton;
    private final String worldName;

    public GuiRestoreBackup(String worldName, final GuiSelectWorld selectWorld) {
        this.worldName = worldName;
        this.backupFiles = (List)worldBackups.get((Object)worldName);
        this.title = StatCollector.func_74837_a((String)"serverutilities.gui.backup.title", (Object[])new Object[]{worldName});
        this.backupFiles.sort(Comparator.comparing(File::lastModified).reversed());
        this.backButton = new SimpleTextButton(this, StatCollector.func_74838_a((String)"gui.cancel"), GuiIcons.CANCEL){

            @Override
            public void onClicked(MouseButton button) {
                this.closeGui();
            }
        };
        this.recreateWorldButton = new SimpleTextButton(this, StatCollector.func_74838_a((String)"selectWorld.recreate"), GuiIcons.REFRESH){

            @Override
            public void onClicked(MouseButton button) {
                try {
                    ReflectionHelper.findMethod(GuiSelectWorld.class, null, (String[])new String[]{"func_146284_a", "actionPerformed"}, (Class[])new Class[]{GuiButton.class}).invoke((Object)selectWorld, new GuiButton(7, 0, 0, 0, 0, ""));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @EventBusSubscriber.Condition
    public static boolean shouldEventBusSubscribe() {
        return ServerUtilitiesConfig.backups.enable_backups;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen guiScreen;
        if (worldBackups == null) {
            worldBackups = new Object2ObjectOpenHashMap();
            GuiRestoreBackup.preProcess();
        }
        if ((guiScreen = event.gui) instanceof GuiSelectWorld) {
            GuiSelectWorld gui = (GuiSelectWorld)guiScreen;
            if (GuiRestoreBackup.needsRefresh()) {
                worldBackups.clear();
                allBackupFiles.clear();
                GuiRestoreBackup.preProcess();
            }
            if (event.gui.field_146294_l / 2 + 248 > event.gui.field_146294_l) {
                return;
            }
            event.buttonList.add(new GuiRestoreButton(event.gui.field_146294_l - 90, event.gui.field_146295_m - 52, 82, 20, StatCollector.func_74838_a((String)"serverutilities.gui.backup.button"), gui));
            gui.field_146292_n.removeIf(button -> button.field_146127_k == 50);
        }
    }

    private static boolean needsRefresh() {
        File[] files = BackupTask.BACKUP_FOLDER.listFiles();
        if (files == null) {
            return false;
        }
        return !allBackupFiles.containsAll(Arrays.asList(files));
    }

    private static void preProcess() {
        File[] files = BackupTask.BACKUP_FOLDER.listFiles();
        if (files == null) {
            return;
        }
        ICompress compressor = ICompress.createCompressor();
        for (File file : files) {
            allBackupFiles.add(file);
            try {
                String worldName = compressor.getWorldName(file);
                if (worldName == null) continue;
                ((List)worldBackups.computeIfAbsent((Object)worldName, k -> new ObjectArrayList())).add(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPostInit() {
        this.setFullscreen();
        this.alignWidgets();
    }

    @Override
    public void alignWidgets() {
        this.backButton.setPos(9, 2);
        this.backButton.setHeight(15);
        this.recreateWorldButton.setPos(9 + this.backButton.width, 2);
        this.recreateWorldButton.setHeight(15);
        this.panelButtons.setPosAndSize(9, 20, this.width - 20 - this.scrollBar.width, this.height - 20);
        super.alignWidgets();
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.closeGui();
            return true;
        }
        return false;
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add(this.backButton);
        this.add(this.recreateWorldButton);
    }

    @Override
    public void addButtons(Panel panel) {
        for (File file : this.backupFiles) {
            ButtonContainer container = new ButtonContainer(panel, file.getName(), Icon.EMPTY);
            container.addSubButton(new BackupEntryButton(panel, StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore"), GuiIcons.ACCEPT, file, this::loadBackupWorld));
            container.addSubButton(new BackupEntryButton(panel, StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore_global"), GuiIcons.ACCEPT, file, this::loadBackupGlobal));
            container.addSubButton(new BackupEntryButton(panel, StatCollector.func_74838_a((String)"selectWorld.delete"), GuiIcons.REMOVE, file, this::deleteBackup));
            container.setXOffset(9);
            panel.add(container);
        }
    }

    private void renameAdditionalFiles(File previousRoot, boolean includeGlobal) {
        for (String pattern : ServerUtilitiesConfig.backups.additional_backup_files) {
            List<File> previousFiles;
            if (!pattern.contains("$WORLDNAME") && !includeGlobal) continue;
            int firstWildcardIndex = (pattern = pattern.replace("$WORLDNAME", this.worldName)).indexOf(42);
            if (firstWildcardIndex == -1) {
                previousFiles = FileUtils.listTree(new File(pattern));
            } else {
                Path rootFolder = Paths.get(pattern.substring(0, firstWildcardIndex), new String[0]);
                if (firstWildcardIndex != 0 && pattern.charAt(firstWildcardIndex - 1) != '/') {
                    rootFolder = rootFolder.getParent();
                }
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                List<File> fileCandidates = FileUtils.listTree(rootFolder.toFile());
                previousFiles = new ArrayList<File>();
                for (File file : fileCandidates) {
                    if (!matcher.matches(file.toPath())) continue;
                    previousFiles.add(file);
                }
            }
            for (File file : previousFiles) {
                String pathRelative = FileUtils.getRelativePath(file);
                File destFile = new File(previousRoot, pathRelative);
                destFile.getParentFile().mkdirs();
                file.renameTo(destFile);
            }
        }
    }

    private void loadBackupWorld(File file) {
        this.openYesNo(StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore_confirm"), StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore_confirm_desc"), () -> this.loadBackup(file, false));
    }

    private void loadBackupGlobal(File file) {
        this.openYesNo(StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore_global_confirm"), StatCollector.func_74838_a((String)"serverutilities.gui.backup.restore_global_confirm_desc"), () -> this.loadBackup(file, true));
    }

    private void loadBackup(File file, boolean includeGlobal) {
        File savesDir = new File("saves/");
        File worldDir = new File(savesDir, this.worldName);
        File saveCopy = new File(savesDir, this.worldName + "_old");
        while (saveCopy.exists()) {
            saveCopy = new File(savesDir, saveCopy.getName() + "_old");
        }
        worldDir.renameTo(saveCopy);
        try (ICompress compressor = ICompress.createCompressor();){
            boolean isOldBackup = compressor.isOldBackup(file);
            if (!isOldBackup) {
                File previousRoot = new File("backups_before_restore/");
                previousRoot = new File(previousRoot, DATE_FORMAT.format(Calendar.getInstance().getTime()));
                this.renameAdditionalFiles(previousRoot, includeGlobal);
            }
            compressor.extractArchive(file, includeGlobal, isOldBackup);
            this.closeGui();
        }
        catch (Exception e) {
            ServerUtilities.LOGGER.error("Failed to restore backup", (Throwable)e);
            FileUtils.delete(worldDir);
            saveCopy.renameTo(worldDir);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiErrorScreen(StatCollector.func_74838_a((String)"serverutilities.gui.backup.error"), EnumChatFormatting.RED + e.getMessage()));
        }
    }

    private void deleteBackup(File file) {
        this.openYesNo(StatCollector.func_74838_a((String)"serverutilities.gui.backup.delete_confirm"), "", () -> {
            FileUtils.delete(file);
            this.backupFiles.remove(file);
        });
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        theme.drawString(EnumChatFormatting.BOLD + this.title, x + (this.width - theme.getStringWidth(this.title)) / 2, 2 + theme.getFontHeight(), 2);
    }

    @Override
    protected Panel createButtonPanel() {
        return new Panel(this){

            @Override
            public void addWidgets() {
                GuiRestoreBackup.this.addButtons(this);
            }

            @Override
            public void alignWidgets() {
                this.setY(21);
                for (Widget w : this.widgets) {
                    w.setX(0);
                    w.setWidth(this.width);
                }
                GuiRestoreBackup.this.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
                GuiRestoreBackup.this.scrollBar.setMaxValue(this.align(new WidgetLayout.Vertical(0, 0, 0)));
                this.getGui().setWidth(((GuiRestoreBackup)GuiRestoreBackup.this).scrollBar.posX + ((GuiRestoreBackup)GuiRestoreBackup.this).scrollBar.width + 8);
                this.getGui().setHeight(this.height + 18);
            }

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(x, y, w, h);
            }
        };
    }

    private static class GuiRestoreButton
    extends GuiButton {
        private final GuiSelectWorld gui;
        private String currentWorld;

        public GuiRestoreButton(int x, int y, int widthIn, int heightIn, String buttonText, GuiSelectWorld gui) {
            super(111, x, y, widthIn, heightIn, buttonText);
            this.gui = gui;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            int worldIndex = this.gui.field_146640_r;
            if (worldIndex == -1) {
                this.field_146124_l = false;
            } else {
                this.currentWorld = ((SaveFormatComparator)this.gui.field_146639_s.get(worldIndex)).func_75786_a();
                this.field_146124_l = worldBackups.containsKey((Object)this.currentWorld);
            }
            super.func_146112_a(mc, mouseX, mouseY);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (!super.func_146116_c(mc, mouseX, mouseY)) {
                return false;
            }
            new GuiRestoreBackup(this.currentWorld, this.gui).openGui();
            return true;
        }
    }

    private static class BackupEntryButton
    extends SimpleTextButton {
        private final File file;
        private final Consumer<File> callback;

        public BackupEntryButton(Panel panel, String text, Icon icon, File file, Consumer<File> callback) {
            super(panel, text, icon);
            this.file = file;
            this.callback = callback;
        }

        @Override
        public void onClicked(MouseButton button) {
            this.callback.accept(this.file);
        }
    }
}

