/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StatCollector;
import serverutils.client.EnumSidebarLocation;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.GuiSidebar;
import serverutils.client.gui.SidebarButton;
import serverutils.client.gui.SidebarButtonGroup;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.misc.MouseButton;

public class GuiSidebarButtonConfig
extends GuiButtonListBase {
    private static final Color4I COLOR_ENABLED = Color4I.rgba(1430765377);
    private static final Color4I COLOR_UNAVAILABLE = Color4I.rgba(1426101503);
    private static final Color4I COLOR_DISABLED = Color4I.rgba(1438401090);

    public GuiSidebarButtonConfig() {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]));
    }

    @Override
    public void addButtons(Panel panel) {
        if (ServerUtilitiesClientConfig.sidebar_buttons == EnumSidebarLocation.UNLOCKED) {
            panel.add(new ButtonResetSidebar(panel));
        }
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
            for (SidebarButton button : group.getButtons()) {
                if (!button.isVisible()) continue;
                panel.add(new ButtonConfigSidebarButton(panel, button));
            }
        }
    }

    @Override
    public void onClosed() {
        super.onClosed();
        SidebarButtonManager.INSTANCE.saveConfig();
    }

    private static class ButtonResetSidebar
    extends SimpleTextButton {
        public ButtonResetSidebar(Panel panel) {
            super(panel, StatCollector.func_74838_a((String)"serverutilities.sidebar_button.reset"), GuiIcons.REFRESH);
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add(StatCollector.func_74838_a((String)"serverutilities.sidebar_button.reset.tooltip"));
        }

        @Override
        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            super.drawBackground(theme, x, y, w, h);
            COLOR_ENABLED.draw(x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiSidebar.dragOffsetX = 0;
            GuiSidebar.dragOffsetY = 0;
        }
    }

    private static class ButtonConfigSidebarButton
    extends SimpleTextButton {
        private final SidebarButton sidebarButton;
        private String tooltip = "";

        public ButtonConfigSidebarButton(Panel panel, SidebarButton s) {
            super(panel, I18n.func_135052_a((String)s.getLangKey(), (Object[])new Object[0]), s.getIcon());
            this.sidebarButton = s;
            if (!LanguageRegistry.instance().getStringLocalization(s.getTooltipLangKey()).isEmpty()) {
                this.tooltip = I18n.func_135052_a((String)s.getTooltipLangKey(), (Object[])new Object[0]);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add(this.sidebarButton.getConfig() ? I18n.func_135052_a((String)"addServer.resourcePack.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"addServer.resourcePack.disabled", (Object[])new Object[0]));
            if (!this.tooltip.isEmpty()) {
                list.add(this.tooltip);
            }
        }

        @Override
        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            super.drawBackground(theme, x, y, w, h);
            (this.sidebarButton.getConfig() ? (this.sidebarButton.isVisible() ? COLOR_ENABLED : COLOR_UNAVAILABLE) : COLOR_DISABLED).draw(x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (ButtonConfigSidebarButton.isCtrlKeyDown()) {
                this.sidebarButton.onClicked(ButtonConfigSidebarButton.isShiftKeyDown());
            } else {
                this.sidebarButton.setConfig(!this.sidebarButton.getConfig());
            }
        }
    }
}

