/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraftforge.client.event.GuiScreenEvent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.gui.ISaveFormatComparatorWithCheatSetter;

@EventBusSubscriber(side={Side.CLIENT})
public class GuiToggleCheatsButton
extends GuiButton {
    private final GuiSelectWorld gui;
    private String currentWorld;

    public GuiToggleCheatsButton(int x, int y, int widthIn, int heightIn, String buttonText, GuiSelectWorld gui) {
        super(112, x, y, widthIn, heightIn, buttonText);
        this.gui = gui;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        int worldIndex = this.gui.field_146640_r;
        if (worldIndex == -1) {
            this.field_146124_l = false;
            this.field_146126_j = StatCollector.func_74838_a((String)"serverutilities.general.toggle_cheats");
        } else {
            SaveFormatComparator saveformatcomparator = (SaveFormatComparator)this.gui.field_146639_s.get(worldIndex);
            this.currentWorld = saveformatcomparator.func_75786_a();
            this.field_146124_l = true;
            this.field_146126_j = saveformatcomparator.func_75783_h() ? StatCollector.func_74838_a((String)"serverutilities.general.disable_cheats") : StatCollector.func_74838_a((String)"serverutilities.general.enable_cheats");
        }
        super.func_146112_a(mc, mouseX, mouseY);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!super.func_146116_c(mc, mouseX, mouseY)) {
            return false;
        }
        try {
            this.toggleCheats(this.currentWorld);
            SaveFormatComparator saveformatcomparator = (SaveFormatComparator)this.gui.field_146639_s.get(this.gui.field_146640_r);
            ((ISaveFormatComparatorWithCheatSetter)saveformatcomparator).serverutilities$setCheatsEnabled(!saveformatcomparator.func_75783_h());
        }
        catch (AnvilConverterException e) {
            e.printStackTrace();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void toggleCheats(String worldName) throws AnvilConverterException {
        File saveFolder = new File(((SaveFormatOld)Minecraft.func_71410_x().func_71359_d()).field_75808_a, worldName);
        if (!saveFolder.exists()) {
            return;
        }
        File levelDataFile = new File(saveFolder, "level.dat");
        if (!levelDataFile.exists()) {
            return;
        }
        try {
            NBTTagCompound parentTag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(levelDataFile));
            NBTTagCompound dataTag = parentTag.func_74775_l("Data");
            byte allowCommands = dataTag.func_74771_c("allowCommands");
            allowCommands = allowCommands == 0 ? (byte)1 : 0;
            dataTag.func_74774_a("allowCommands", allowCommands);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parentTag, (OutputStream)new FileOutputStream(levelDataFile));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @EventBusSubscriber.Condition
    public static boolean shouldEventBusSubscribe() {
        return ServerUtilitiesConfig.general.enable_toggle_cheats_button;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen guiScreen = event.gui;
        if (guiScreen instanceof GuiSelectWorld) {
            GuiSelectWorld gui = (GuiSelectWorld)guiScreen;
            if (gui.field_146294_l / 2 + 248 > gui.field_146294_l) {
                return;
            }
            event.buttonList.add(new GuiToggleCheatsButton(gui.field_146294_l - 90, gui.field_146295_m - 28, 82, 20, StatCollector.func_74838_a((String)"serverutilities.general.toggle_cheats"), gui));
        }
    }
}

