/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S38PacketPlayerListItem;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.VanishData;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CmdSimple;
import serverutils.lib.command.CmdTreeBase;
import serverutils.lib.command.CmdTreeHelp;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.permission.PermissionAPI;

public class CmdVanish
extends CmdTreeBase {
    public CmdVanish() {
        super("vanish");
        this.addSubcommand(new CmdVanishToggle());
        this.addSubcommand(new CmdVanishCheck());
        this.addSubcommand(new CmdSimple("fakequit", CmdBase.Level.OP, sender -> CmdVanish.sendConnectionMessage(sender, true)));
        this.addSubcommand(new CmdSimple("fakejoin", CmdBase.Level.OP, sender -> CmdVanish.sendConnectionMessage(sender, false)));
        for (VanishData.DataType type : VanishData.DataType.values()) {
            this.addSubcommand(new CmdVanishSub(type));
        }
        this.addSubcommand((ICommand)new CmdTreeHelp(this));
    }

    private static void sendConnectionMessage(ICommandSender sender, boolean vanish) {
        ChatComponentTranslation message = new ChatComponentTranslation("multiplayer.player." + (vanish ? "left" : "joined"), new Object[]{sender.func_145748_c_()});
        for (EntityPlayerMP playerMP : Universe.get().server.func_71203_ab().field_72404_b) {
            if (playerMP == sender || PermissionAPI.hasPermission((EntityPlayer)playerMP, "serverutilities.vanish.see")) continue;
            playerMP.func_145747_a((IChatComponent)message);
        }
    }

    private static void updateVanishStatus(EntityPlayerMP playerToUpdate, boolean vanish) {
        Universe universe = Universe.get();
        EntityTrackerEntry playerTracker = CmdVanish.getTrackerEntry(playerToUpdate);
        if (playerTracker == null) {
            return;
        }
        playerToUpdate.field_70170_p.func_72872_a(EntityCreature.class, playerToUpdate.field_70121_D.func_72314_b(40.0, 40.0, 40.0)).forEach(entity -> {
            if (playerToUpdate.equals((Object)entity.func_70777_m())) {
                entity.func_70784_b(null);
            }
            if (playerToUpdate.equals((Object)entity.func_70638_az())) {
                entity.func_70624_b(null);
            }
            if (playerToUpdate.equals((Object)entity.func_70643_av())) {
                entity.func_70604_c(null);
            }
        });
        S38PacketPlayerListItem tablistPacket = vanish ? new S38PacketPlayerListItem(playerToUpdate.func_70005_c_(), false, 9999) : new S38PacketPlayerListItem(playerToUpdate.func_70005_c_(), true, playerToUpdate.field_71138_i);
        for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
            if (player == playerToUpdate || PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.vanish.see")) continue;
            player.field_71135_a.func_147359_a((Packet)tablistPacket);
            if (vanish) {
                playerTracker.func_73123_c(player);
            } else {
                playerTracker.field_73144_s = false;
                playerTracker.func_73117_b(player);
            }
            VanishData data = ServerUtilitiesPlayerData.get((ICommandSender)playerToUpdate).getVanishData();
            if (!data.sendConnectionMessage) continue;
            CmdVanish.sendConnectionMessage((ICommandSender)player, vanish);
        }
    }

    private static EntityTrackerEntry getTrackerEntry(EntityPlayerMP player) {
        return player.func_71121_q().func_73039_n().field_72793_b.stream().filter(entry -> ((EntityTrackerEntry)entry).field_73132_a == player).findFirst().orElse(null);
    }

    public static class CmdVanishToggle
    extends CmdBase {
        public CmdVanishToggle() {
            super("toggle", CmdBase.Level.OP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            boolean toVanish;
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            NBTTagCompound tag = NBTUtils.getPersistedData((EntityPlayer)player, true);
            Universe universe = Universe.get();
            ForgePlayer forgePlayer = universe.getPlayer(player.func_110124_au());
            if (forgePlayer == null) {
                return;
            }
            boolean bl = toVanish = !tag.func_74767_n("vanish");
            if (args.length == 1) {
                boolean bl2 = toVanish = !args[0].equals("off") && !args[0].equals("false");
            }
            if (toVanish) {
                tag.func_74757_a("vanish", true);
                universe.vanishedPlayers.add(forgePlayer);
                player.field_71075_bZ.field_75102_a = true;
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.vanish.on", new Object[0]));
                CmdVanish.updateVanishStatus(player, true);
            } else {
                tag.func_82580_o("vanish");
                universe.vanishedPlayers.remove(forgePlayer);
                player.field_71075_bZ.field_75102_a = false;
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.vanish.off", new Object[0]));
                CmdVanish.updateVanishStatus(player, false);
            }
        }
    }

    public static class CmdVanishCheck
    extends CmdBase {
        public CmdVanishCheck() {
            super("check", CmdBase.Level.OP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (ServerUtils.isVanished((Entity)player)) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.vanish.check.true", new Object[0]));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.vanish.check.false", new Object[0]));
            }
        }
    }

    public static class CmdVanishSub
    extends CmdBase {
        private final VanishData.DataType type;

        public CmdVanishSub(VanishData.DataType type) {
            super(type.name, CmdBase.Level.OP);
            this.type = type;
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            VanishData data = ServerUtilitiesPlayerData.get((ICommandSender)player).getVanishData();
            boolean state = args.length == 1 ? data.setState(this.type, CmdVanishSub.func_110662_c((ICommandSender)sender, (String)args[0])) : data.toggleState(this.type);
            String stateStr = " " + StatCollector.func_74838_a((String)("addServer.resourcePack." + (state ? "enabled" : "disabled"))).toLowerCase();
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("commands.vanish." + this.func_71517_b())) + stateStr));
        }

        @Override
        public String func_71518_a(ICommandSender sender) {
            return StatCollector.func_74838_a((String)super.func_71518_a(sender)) + " - " + this.type.desc;
        }
    }
}

