/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.client;

import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.status.INetHandlerStatusClient;
import net.minecraft.network.status.client.C00PacketServerQuery;
import net.minecraft.network.status.client.C01PacketPing;
import net.minecraft.network.status.server.S00PacketServerInfo;
import net.minecraft.network.status.server.S01PacketPong;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.util.StringUtils;

public class CommandPing
extends CmdBase {
    private static final Executor EXECUTOR = Executors.newScheduledThreadPool(1);

    public CommandPing() {
        super("ping", CmdBase.Level.ALL);
    }

    public void func_71515_b(final ICommandSender sender, String[] strings) throws CommandException {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71401_C() != null) {
            sender.func_145747_a(ServerUtilities.lang(sender, "commands.ping.integrated_server", new Object[0]));
            return;
        }
        ServerData data = mc.func_147104_D();
        if (data != null) {
            EXECUTOR.execute(() -> {
                ServerAddress address = ServerAddress.func_78860_a((String)data.field_78845_b);
                try {
                    final NetworkManager networkManager = NetworkManager.func_150726_a((InetAddress)InetAddress.getByName(address.func_78861_a()), (int)address.func_78864_b());
                    networkManager.func_150719_a((INetHandler)new INetHandlerStatusClient(){
                        private long latency = -1L;
                        private long sendAt;

                        public void func_147397_a(S00PacketServerInfo sPacketServerInfo) {
                            this.sendAt = Minecraft.func_71386_F();
                            networkManager.func_150725_a((Packet)new C01PacketPing(this.sendAt), new GenericFutureListener[0]);
                        }

                        public void func_147398_a(S01PacketPong sPacketPong) {
                            this.latency = Minecraft.func_71386_F() - this.sendAt;
                            networkManager.func_150718_a((IChatComponent)new ChatComponentText("Finished"));
                            sender.func_145747_a(ServerUtilities.lang(sender, "commands.ping.ping", StringUtils.getTimeString(this.latency)));
                        }

                        public void func_147231_a(IChatComponent component) {
                            if (this.latency == -1L) {
                                sender.func_145747_a(ServerUtilities.lang(sender, "commands.ping.unknown", new Object[0]));
                            }
                        }

                        public void func_147232_a(EnumConnectionState arg0, EnumConnectionState arg1) {
                        }

                        public void func_147233_a() {
                        }
                    });
                    networkManager.func_150725_a((Packet)new C00Handshake(5, address.func_78861_a(), address.func_78864_b(), EnumConnectionState.STATUS), new GenericFutureListener[0]);
                    networkManager.func_150725_a((Packet)new C00PacketServerQuery(), new GenericFutureListener[0]);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    sender.func_145747_a(ServerUtilities.lang(sender, "commands.ping.unknown", new Object[0]));
                }
            });
            return;
        }
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.ping.unknown", new Object[0]));
    }
}

