/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.ranks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.util.StringUtils;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;
import serverutils.ranks.ServerUtilitiesPermissionHandler;

public class CmdSetPermission
extends CmdBase {
    public static final List<String> PERM_VARIANTS = Arrays.asList("true", "false", "none");

    public CmdSetPermission() {
        super("set_permission", CmdBase.Level.OP);
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("setp");
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return Ranks.isActive() ? CmdSetPermission.func_71531_a((String[])args, Ranks.INSTANCE.getRankNames(false)) : Collections.emptyList();
        }
        if (args.length == 2) {
            return Ranks.matchPossibleNodes(args[args.length - 1], Ranks.isActive() ? Ranks.INSTANCE.getPermissionNodes() : ServerUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes());
        }
        if (args.length == 3) {
            RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(args[1]);
            if (info != null && !info.defaultValue.isNull()) {
                ArrayList<String> list = new ArrayList<String>(info.defaultValue.getVariants());
                list.add("none");
                return CmdSetPermission.func_71531_a((String[])args, list);
            }
            return CmdSetPermission.func_71531_a((String[])args, PERM_VARIANTS);
        }
        return super.func_71516_a(sender, args);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        String value;
        if (!Ranks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        this.checkArgs(sender, args, 3);
        Rank rank = Ranks.INSTANCE.getRank(sender, args[0]);
        String node = args[1];
        String value0 = StringUtils.joinSpaceUntilEnd(2, args);
        String string = value = value0.equals("none") ? "" : value0;
        if (value.length() > 2 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if (rank.setPermission(node, value) == null) {
            sender.func_145747_a(ServerUtilities.lang(sender, "nothing_changed", new Object[0]));
        } else {
            ChatComponentText setText;
            rank.ranks.save();
            ChatComponentText nodeText = new ChatComponentText(node);
            nodeText.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
            if (value.isEmpty()) {
                setText = ServerUtilities.lang(sender, "commands.ranks.none", new Object[0]);
                setText.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GRAY);
            } else {
                setText = new ChatComponentText(value);
                switch (value) {
                    case "true": {
                        setText.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                        break;
                    }
                    case "false": {
                        setText.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                        break;
                    }
                    default: {
                        setText.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
                    }
                }
            }
            sender.func_145747_a(ServerUtilities.lang(sender, "commands.ranks.set_permission.set", nodeText, rank.getDisplayName(), setText));
        }
    }
}

