/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.BlockDimPosStorage;
import serverutils.data.TeleportLog;
import serverutils.data.TeleportTracker;
import serverutils.data.TeleportType;
import serverutils.data.VanishData;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.PlayerData;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.TextComponentParser;
import serverutils.net.MessageUpdateTabName;
import serverutils.ranks.Ranks;
import serverutils.task.Task;
import serverutils.task.TeleportTask;

public class ServerUtilitiesPlayerData
extends PlayerData {
    public static final String TAG_FLY = "fly";
    public static final String TAG_MUTED = "muted";
    public static final String TAG_LAST_CHUNK = "serveru_lchunk";
    private boolean enablePVP = true;
    private boolean showTeamPrefix = false;
    private String nickname = "";
    public final Collection<ForgePlayer> tpaRequestsFrom;
    public long afkTime;
    private IChatComponent cachedNameForChat;
    private BlockDimPos lastSafePos;
    public final BlockDimPosStorage homes = new BlockDimPosStorage();
    private final TeleportTracker teleportTracker;
    private final VanishData vanishData;

    public static ServerUtilitiesPlayerData get(ForgePlayer player) {
        return (ServerUtilitiesPlayerData)player.getData().get("serverutilities");
    }

    public static ServerUtilitiesPlayerData get(ICommandSender player) {
        return ServerUtilitiesPlayerData.get(Universe.get().getPlayer(player));
    }

    @Nullable
    public static ServerUtilitiesPlayerData getNullable(EntityPlayer player) {
        ForgePlayer fp = Universe.get().getPlayer(player.func_146103_bH());
        return fp == null ? null : ServerUtilitiesPlayerData.get(fp);
    }

    public ServerUtilitiesPlayerData(ForgePlayer player) {
        super(player);
        this.tpaRequestsFrom = new HashSet<ForgePlayer>();
        this.teleportTracker = new TeleportTracker();
        this.vanishData = new VanishData();
    }

    @Override
    public String getId() {
        return "serverutilities";
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("EnablePVP", this.enablePVP);
        nbt.func_74757_a("ShowTeamPrefix", this.showTeamPrefix);
        nbt.func_74782_a("Homes", (NBTBase)this.homes.serializeNBT());
        nbt.func_74782_a("TeleportTracker", (NBTBase)this.teleportTracker.serializeNBT());
        nbt.func_74778_a("Nickname", this.nickname);
        nbt.func_74782_a("VanishData", (NBTBase)this.vanishData.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.enablePVP = !nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP");
        this.showTeamPrefix = nbt.func_74767_n("ShowTeamPrefix");
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.teleportTracker.deserializeNBT(nbt.func_74775_l("TeleportTracker"));
        this.setLastDeath(BlockDimPos.fromIntArray(nbt.func_74759_k("LastDeath")), 0L);
        this.nickname = nbt.func_74779_i("Nickname");
        this.vanishData.deserializeNBT(nbt.func_74775_l("VanishData"));
    }

    public void addConfig(ConfigGroup main) {
        ConfigGroup config = main.getGroup("serverutilities");
        config.setDisplayName((IChatComponent)new ChatComponentText("Server Utilities"));
        config.addBool("enable_pvp", () -> this.enablePVP, v -> {
            this.enablePVP = v;
        }, true).setCanEdit(ServerUtilitiesConfig.world.enable_pvp.isDefault());
        config.addString("nickname", () -> this.nickname, v -> {
            this.nickname = v;
        }, "").setCanEdit(ServerUtilitiesConfig.commands.nick && this.player.hasPermission("serverutilities.chat.nickname.set"));
        if (this.player.hasPermission("serverutilities.vanish.see")) {
            this.vanishData.addConfigs(main);
        }
    }

    public boolean enablePVP() {
        return this.enablePVP;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String name) {
        this.nickname = name.equals(this.player.getName()) ? "" : name;
        this.player.markDirty();
        this.clearCache();
    }

    public void setLastDeath(@Nullable BlockDimPos pos) {
        this.setLastDeath(pos, MinecraftServer.func_130071_aq());
    }

    public void setLastDeath(@Nullable BlockDimPos pos, long timestamp) {
        if (pos == null) {
            return;
        }
        this.teleportTracker.logTeleport(TeleportType.RESPAWN, pos, timestamp);
        this.player.markDirty();
    }

    public BlockDimPos getLastDeath() {
        return this.teleportTracker.getLastDeath().getBlockDimPos();
    }

    public void setLastSafePos(@Nullable BlockDimPos pos) {
        this.lastSafePos = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastSafePos() {
        return this.lastSafePos;
    }

    public void checkTeleportCooldown(ICommandSender sender, TeleportType teleportType) throws CommandException {
        String cooldownPermission = teleportType.getCooldownPermission();
        if (cooldownPermission == null) {
            return;
        }
        long cooldown = this.teleportTracker.getLastTeleportTime(teleportType) + this.player.getRankConfig(cooldownPermission).getTimer().millis() - System.currentTimeMillis();
        if (cooldown > 0L) {
            throw ServerUtilities.error(sender, "cant_use_now_cooldown", StringUtils.getTimeString(cooldown));
        }
    }

    @Override
    public void clearCache() {
        this.cachedNameForChat = null;
        if (this.player.isFake()) {
            return;
        }
        EntityPlayerMP p = this.player.getNullablePlayer();
        if (p == null) {
            return;
        }
        p.refreshDisplayName();
        if (ServerUtilitiesConfig.chat.replace_tab_names) {
            this.getNameForChat();
        }
    }

    public IChatComponent getNameForChat() {
        EntityPlayerMP playerMP = this.player.getNullablePlayer();
        if (playerMP == null) {
            return new ChatComponentText("");
        }
        if (ServerUtils.isFake(playerMP)) {
            return new ChatComponentText(this.player.getName());
        }
        if (this.cachedNameForChat != null) {
            return this.cachedNameForChat.func_150259_f();
        }
        if (Ranks.isActive() && ServerUtilitiesConfig.ranks.override_chat) {
            String donorPrefix = this.player.getRankConfig("serverutilities.chat.donor_prefix").getString();
            String text = this.player.getRankConfig("serverutilities.chat.name_format").getString();
            try {
                this.cachedNameForChat = new ChatComponentText("");
                if (!donorPrefix.isEmpty()) {
                    IChatComponent donorComponent = TextComponentParser.parse(donorPrefix, ServerUtilitiesCommon.chatFormattingSubstituteFunction(this.player));
                    this.cachedNameForChat.func_150257_a(donorComponent);
                    this.cachedNameForChat.func_150258_a(" ");
                }
                IChatComponent nameComponent = TextComponentParser.parse(text, ServerUtilitiesCommon.chatFormattingSubstituteFunction(this.player));
                this.cachedNameForChat.func_150257_a(nameComponent);
            }
            catch (Exception ex) {
                String s = "Error parsing " + text + ": " + ex.getLocalizedMessage();
                ServerUtilities.LOGGER.error(s);
                this.cachedNameForChat = new ChatComponentText("BrokenFormatting");
                this.cachedNameForChat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                this.cachedNameForChat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(s)));
            }
        } else {
            this.cachedNameForChat = new ChatComponentText(this.player.getDisplayNameString());
        }
        if (NBTUtils.getPersistedData((EntityPlayer)playerMP, false).func_74767_n("recording")) {
            ChatComponentText rec = new ChatComponentText("\u25a0 ");
            rec.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            this.cachedNameForChat = new ChatComponentText("").func_150257_a((IChatComponent)rec).func_150257_a(this.cachedNameForChat);
        }
        if (ServerUtilitiesConfig.chat.replace_tab_names && !this.cachedNameForChat.func_150260_c().equals(this.player.getName())) {
            new MessageUpdateTabName(this.player, this.cachedNameForChat).sendToAll();
        }
        this.cachedNameForChat.func_150258_a(" ");
        return this.cachedNameForChat.func_150259_f();
    }

    public void teleport(TeleporterDimPos pos, TeleportType teleportType, @Nullable Task extraTask) {
        int seconds;
        EntityPlayerMP player = this.player.getPlayer();
        Universe universe = Universe.get();
        String warmup = teleportType.getWarmupPermission();
        int n = seconds = warmup == null ? 0 : (int)RankConfigAPI.get(player, warmup).getTimer().seconds();
        if (seconds > 0) {
            IChatComponent component = StringUtils.color(ServerUtilities.lang((ICommandSender)player, "stand_still", seconds).func_150258_a(" [" + seconds + "]"), EnumChatFormatting.GOLD);
            ServerUtilitiesNotifications.TELEPORT_WARMUP.createNotification(component).setVanilla(true).send((EntityPlayer)player);
            universe.scheduleTask(new TeleportTask(teleportType, player, seconds, pos, extraTask));
        } else {
            new TeleportTask(teleportType, player, 0, pos, extraTask).execute(universe);
        }
    }

    public TeleportLog getLastTeleportLog() {
        return this.teleportTracker.getLastAvailableLog(this.player.getProfile());
    }

    public void setLastTeleport(TeleportType teleportType, BlockDimPos from) {
        this.teleportTracker.logTeleport(teleportType, from, MinecraftServer.func_130071_aq());
        this.player.markDirty();
    }

    public void clearLastTeleport(TeleportType teleportType) {
        this.teleportTracker.clearLog(teleportType);
        this.player.markDirty();
    }

    public VanishData getVanishData() {
        return this.vanishData;
    }
}

