/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.core.BattlegearUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.inventories.InvSeeInventories;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ImageIcon;

public class BattlegearInventory
implements IModdedInventory {
    private static final int SLOT_AMOUNT = 6;
    private static final Icon BG_ICON = new ImageIcon(new ResourceLocation("battlegear2", "textures/items/bg-icon.png"));

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return player.field_71071_by;
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        return InvSeeInventories.MAIN.getInventory().loadOfflineInventory(player);
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryPlayer(player);
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return BG_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Battlegear";
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        if (index >= 6) {
            return null;
        }
        int inventorySlot = 150 + index / 2;
        x = 62;
        if ((index & 1) != 0) {
            inventorySlot += 3;
            x += 36;
        }
        return new WeaponSlotNoPartner(inventory, inventorySlot, x, y - 36 + index / 2 * 18);
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (player.isOnline()) {
            return;
        }
        NBTTagCompound tag = player.getPlayerNBT();
        InventoryPlayer playerInv = new InventoryPlayer(null);
        playerInv.func_70443_b(tag.func_150295_c("Inventory", 10));
        for (int i = 0; i < 6; ++i) {
            int slot = 150 + i;
            ItemStack stack = inventory.func_70301_a(slot);
            playerInv.func_70299_a(slot, stack);
        }
        NBTTagList invTag = new NBTTagList();
        playerInv.func_70442_a(invTag);
        tag.func_74782_a("Inventory", (NBTBase)invTag);
        player.setPlayerNBT(tag);
    }

    private static class WeaponSlotNoPartner
    extends Slot {
        private final boolean mainHand;

        public WeaponSlotNoPartner(IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.mainHand = index < 153;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon func_75212_b() {
            GL11.glEnable((int)3008);
            return Battlegear.proxy.getSlotIcon(this.mainHand ? 0 : 1);
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            if (stack == null) {
                return true;
            }
            if (this.mainHand) {
                ItemStack offHandStack = this.field_75224_c.func_70301_a(this.getSlotIndex() + 3);
                return BattlegearUtils.isMainHand((ItemStack)stack, (ItemStack)offHandStack);
            }
            if (BattlegearUtils.isOffHand((ItemStack)stack)) {
                ItemStack mainHandStack = this.field_75224_c.func_70301_a(this.getSlotIndex() - 3);
                return BattlegearUtils.isMainHand((ItemStack)mainHandStack, (ItemStack)stack);
            }
            return false;
        }
    }
}

